﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.Course;
using Edu.Repository.Course;
using Microsoft.AspNetCore.Mvc.ModelBinding;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Edu.Module.Course
{
    /// <summary>
    /// 课程处理类
    /// </summary>
    public class CourseModule
    {
        /// <summary>
        /// 课程章节仓储层对象
        /// </summary>
        private readonly RB_Course_ChapterRepository chapterRepository = new RB_Course_ChapterRepository();

        /// <summary>
        /// 课程通知仓储层对象
        /// </summary>
        private readonly RB_Course_NoticeRepository noticeRepository = new RB_Course_NoticeRepository();

        /// <summary>
        /// 课程通知接收仓储层对象
        /// </summary>
        private readonly RB_Course_NoticeReviceRepository noticeReviceRepository = new RB_Course_NoticeReviceRepository();

        /// <summary>
        /// 课程处理仓储层对象
        /// </summary>
        private readonly RB_CourseRepository courseRepository = new RB_CourseRepository();


        /// <summary>
        /// 获取课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_ViewModel> GetCourseListModule(RB_Course_ViewModel query)
        {
            return courseRepository.GetCourseListRepository(query);
        }

        /// <summary>
        /// 获取课程分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_ViewModel> GetCoursePageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Course_ViewModel query)
        {
            return courseRepository.GetCoursePageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 根据课程编号获取课程实体
        /// </summary>
        /// <param name="CourseId"></param>
        /// <returns></returns>
        public RB_Course_ViewModel GetCourseModule(object CourseId)
        {
            return courseRepository.GetEntity<RB_Course_ViewModel>(CourseId);
        }

        /// <summary>
        /// 新增修改课程
        /// </summary>
        /// <returns></returns>
        public bool SetCourseModule(RB_Course_ViewModel model)
        {
            bool flag;
            if (model.CourseId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Course_ViewModel.CoverImg),model.CoverImg },
                    {nameof(RB_Course_ViewModel.CourseName),model.CourseName },
                    {nameof(RB_Course_ViewModel.CourseIntro),model.CourseIntro },
                    {nameof(RB_Course_ViewModel.CateId),model.CateId },
                };
                flag = courseRepository.Update(fileds, new WhereHelper(nameof(RB_Course_ViewModel.CourseId), model.CourseId));
            }
            else
            {
                var newId = courseRepository.Insert(model);
                model.CourseId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 是否显示章节编号
        /// </summary>
        /// <param name="CourseId"></param>
        /// <param name="IsShowChapterNo">是否显示章节编号(1-显示，0-不显示)</param>
        /// <returns></returns>
        public bool SetCourseIsShowChapterNo(int CourseId, int IsShowChapterNo)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Course_ViewModel.IsShowChapterNo),IsShowChapterNo },
            };
            bool flag = courseRepository.Update(fileds, new WhereHelper(nameof(RB_Course_ViewModel.CourseId), CourseId));
            return flag;
        }

        /// <summary>
        /// 删除课程
        /// </summary>
        /// <param name="CourseId"></param>
        /// <returns></returns>
        public bool RemoveCourseModule(object CourseId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Course_ViewModel.Status),(int)DateStateEnum.Delete },
            };
            bool flag = courseRepository.Update(fileds, new WhereHelper(nameof(RB_Course_ViewModel.CourseId), CourseId));
            return flag;
        }

        /// <summary>
        /// 新增修改课程通知
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetNoticeModule(RB_Course_Notice_ViewModel model)
        {
            bool flag;
            if (model.NoticeId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Course_Notice_ViewModel.Title),model.Title }
                };
                flag = noticeRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Notice_ViewModel.NoticeId), model.NoticeId));
            }
            else
            {
                var newId = noticeRepository.Insert(model);
                model.NoticeId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取课程通知实体
        /// </summary>
        /// <param name="NoticeId"></param>
        /// <returns></returns>
        public RB_Course_Notice_ViewModel GetNoticeModule(object NoticeId)
        {
            return noticeRepository.GetEntity<RB_Course_Notice_ViewModel>(NoticeId);
        }

        /// <summary>
        /// 根据通知编号删除通知
        /// </summary>
        /// <param name="NoticeId"></param>
        /// <returns></returns>
        public bool RemoveNoticeModule(object NoticeId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Course_Notice_ViewModel.Status), (int)DateStateEnum.Delete}
            };
            bool flag = noticeRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Notice_ViewModel.NoticeId), NoticeId));
            return flag;
        }

        /// <summary>
        /// 新增通知阅读
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddNoticeRevice(RB_Course_NoticeRevice_ViewModel model)
        {
            var newId = noticeReviceRepository.Insert(model);
            model.ReviceId = newId;
            return newId > 0;
        }
    }
}
