﻿using Edu.Model.ViewModel.System;
using Edu.Repository.System;
using System.Collections.Generic;
using System.Linq;
using VT.FW.DB;

namespace Edu.Module.System
{
    /// <summary>
    /// 菜单处理类
    /// </summary>
    public class MenuModule
    {
        /// <summary>
        /// 系统菜单仓储层对象
        /// </summary>
        private readonly RB_MenuRepository menuRepository = new RB_MenuRepository();

        /// <summary>
        /// 获取菜单列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Menu_ViewModel> GetMenuListModule(RB_Menu_ViewModel query)
        {
            return menuRepository.GetMenuListRepository(query);
        }

        /// <summary>
        /// 获取菜单分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Menu_ViewModel> GetMenuPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Menu_ViewModel query)
        {
            return menuRepository.GetMenuPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 新增修改菜单
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public virtual bool SetMenuModule(RB_Menu_ViewModel model)
        {
            bool flag;
            if (model.MenuId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Menu_ViewModel.MenuName),model.MenuName.Trim() },
                    {nameof(RB_Menu_ViewModel.ParentId),model.ParentId },
                    {nameof(RB_Menu_ViewModel.MenuUrl),model.MenuUrl },
                    {nameof(RB_Menu_ViewModel.MenuIcon),model.MenuIcon },
                    {nameof(RB_Menu_ViewModel.MenuLevel),model.MenuLevel },
                    {nameof(RB_Menu_ViewModel.MenuType),model.MenuType },
                    {nameof(RB_Menu_ViewModel.SortNum),model.SortNum },
                };
                flag = menuRepository.Update(fileds, new WhereHelper(nameof(RB_Menu_ViewModel.MenuId), model.MenuId));
            }
            else
            {
                var newId = menuRepository.Insert(model);
                model.MenuId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据菜单编号获取菜单实体
        /// </summary>
        /// <param name="MenuId"></param>
        /// <returns></returns>
        public RB_Menu_ViewModel GetMenuModule(object MenuId)
        {
            return menuRepository.GetEntity<RB_Menu_ViewModel>(MenuId);
        }

        /// <summary>
        /// 更新菜单状态
        /// </summary>
        /// <param name="MenuId"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool SetMenuStatusModule(int MenuId, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Menu_ViewModel.Status),Status },
            };
            bool flag = menuRepository.Update(fileds, new WhereHelper(nameof(RB_Menu_ViewModel.MenuId), MenuId));
            return flag;
        }

        /// <summary>
        /// 获取树形菜单
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<MenuTree_ViewModel> GetTreeMenuModule(RB_Menu_ViewModel query)
        {
            List<MenuTree_ViewModel> treeList = new List<MenuTree_ViewModel>();
            var list= GetMenuListModule(query);
            if (list != null && list.Count > 0)
            {
                //一级菜单
                var firstLevelList = list.Where(qitem => qitem.MenuLevel == 1).ToList();
                if (firstLevelList != null && firstLevelList.Count > 0)
                {
                    foreach (var fItem in firstLevelList)
                    {
                        MenuTree_ViewModel fModel = new MenuTree_ViewModel()
                        {
                            MenuId = fItem.MenuId,
                            MenuName = fItem.MenuName,
                            MenuUrl = fItem.MenuUrl,
                            MenuIcon=fItem.MenuIcon,
                            SubList = new List<MenuTree_ViewModel>()
                        };
                        //二级菜单
                        var secondLevelList= list.Where(qitem => qitem.MenuLevel == 2&&qitem.ParentId==fItem.MenuId).ToList();
                        if (secondLevelList != null && secondLevelList.Count > 0)
                        {
                            foreach (var sItem in secondLevelList)
                            {
                                MenuTree_ViewModel sModel = new MenuTree_ViewModel()
                                {
                                    MenuId = sItem.MenuId,
                                    MenuName = sItem.MenuName,
                                    MenuUrl = sItem.MenuUrl,
                                    MenuIcon = sItem.MenuIcon,
                                    SubList = new List<MenuTree_ViewModel>()
                                };
                                //三级菜单
                                var thirdLevelList= list.Where(qitem => qitem.MenuLevel == 3 && qitem.ParentId == sItem.MenuId).ToList();
                                if (thirdLevelList != null && thirdLevelList.Count > 0)
                                {
                                    foreach (var tItem in thirdLevelList)
                                    {
                                        sModel.SubList.Add(new MenuTree_ViewModel()
                                        {
                                            MenuId = tItem.MenuId,
                                            MenuName = tItem.MenuName,
                                            MenuUrl = tItem.MenuUrl,
                                            MenuIcon = tItem.MenuIcon,
                                            SubList = new List<MenuTree_ViewModel>()
                                        });
                                    }
                                }
                                fModel.SubList.Add(sModel);
                            }
                        }
                        treeList.Add(fModel);
                    }
                }
            }
            return treeList;
        }
    }
}