﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.System;
using Edu.Repository.System;
using System.Collections.Generic;
using VT.FW.DB;

namespace Edu.Module.System
{
    /// <summary>
    /// 角色处理类
    /// </summary>
    public class RoleModule
    {
        /// <summary>
        /// 角色仓储层对象
        /// </summary>
        private readonly RB_RoleRepository roleRepository = new RB_RoleRepository();

        /// <summary>
        /// 获取角色列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Role_ViewModel> GetRoleListModule(RB_Role_ViewModel query)
        {
            return roleRepository.GetRoleListRepository(query);
        }

        /// <summary>
        /// 获取角色分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Role_ViewModel> GetRolePageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Role_ViewModel query)
        {
            return roleRepository.GetRolePageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 新增修改角色
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetRoleModule(RB_Role_ViewModel model)
        {
            bool flag;
            if (model.RoleId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Role_ViewModel.RoleName),model.RoleName.Trim() },
                    {nameof(RB_Role_ViewModel.RoleIntro),model.RoleIntro },
                    {nameof(RB_Role_ViewModel.RoleAuth),model.RoleAuth },
                };
                flag = roleRepository.Update(fileds, new WhereHelper(nameof(RB_Role_ViewModel.RoleId), model.RoleId));
            }
            else
            {
                var newId = roleRepository.Insert(model);
                model.RoleId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取角色实体
        /// </summary>
        /// <param name="RoleId"></param>
        /// <returns></returns>
        public RB_Role_ViewModel GetRoleModule(object RoleId)
        {
            return roleRepository.GetEntity<RB_Role_ViewModel>(RoleId);
        }

        /// <summary>
        /// 删除角色
        /// </summary>
        /// <param name="RoleId"></param>
        /// <returns></returns>
        public bool RemoveRoleModule(object RoleId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Role_ViewModel.Status),(int)DateStateEnum.Delete},
            };
            bool flag = roleRepository.Update(fileds, new WhereHelper(nameof(RB_Role_ViewModel.RoleId), RoleId));
            return flag;
        }
    }
}