﻿using Edu.AOP.CustomerAttribute;
using Edu.Common.Enum;
using Edu.Common.Enum.User;
using Edu.Model.CacheModel;
using Edu.Model.Entity.User;
using Edu.Model.ViewModel.User;
using Edu.Repository.User;
using System;
using System.Collections.Generic;
using System.Linq;
using VT.FW.DB;

namespace Edu.Module.User
{
    /// <summary>
    /// 助教处理类
    /// </summary>
    public class AssistModule
    {
        /// <summary>
        /// 助教仓储层对象
        /// </summary>
        private readonly RB_AssistRepository assistRepository = new RB_AssistRepository();

        /// <summary>
        /// 账号处理类
        /// </summary>
        private readonly AccountModule accountModule = new AccountModule();

        /// <summary>
        /// 获取助教列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Assist_ViewModel> GetAssistListModule(RB_Assist_ViewModel query)
        {
            return assistRepository.GetAssistListRepository(query);
        }


        /// <summary>
        /// 获取助教分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Assist_ViewModel> GetAssistPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Assist_ViewModel query)
        {
            return assistRepository.GetAssistPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 添加修改助教
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetAssistModule(RB_Assist model)
        {
            bool flag;
            if (model.AId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Assist.School_Id),model.School_Id },
                    {nameof(RB_Assist.Teacher_Id),model.Teacher_Id },
                    {nameof(RB_Assist.Teacher_Id),model.Teacher_Id },
                    {nameof(RB_Assist.AssistName),model.AssistName.Trim() },
                    {nameof(RB_Assist.AssistTel),model.AssistTel },
                    {nameof(RB_Assist.AssistIcon),model.AssistIcon },
                    {nameof(RB_Assist.AssistIntro),model.AssistIntro },
                    {nameof(RB_Assist.UpdateBy),model.UpdateBy },
                    {nameof(RB_Assist.UpdateTime),model.UpdateTime },
                };
                flag = assistRepository.Update(fileds, new WhereHelper(nameof(RB_Assist.AId), model.AId));
            }
            else
            {
                var newId = assistRepository.Insert(model);
                model.AId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据编号获取助教实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Assist_ViewModel GetAssistModule(int AId)
        {
            return GetAssistListModule(new RB_Assist_ViewModel() { AId = AId })?.FirstOrDefault() ?? new RB_Assist_ViewModel();
        }

        /// <summary>
        /// 根据编号移除助教
        /// </summary>
        /// <param name="AId"></param>
        /// <returns></returns>
        public bool RemoveAssistModule(object AId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Assist.Status),(int)DateStateEnum.Delete },
            };
            bool flag = assistRepository.Update(fileds, new WhereHelper(nameof(RB_Assist.AId), AId));
            return flag;
        }

        /// <summary>
        /// 讲师审核
        /// </summary>
        /// <param name="AId">助教编号</param>
        /// <param name="AuditStatus">审核状态</param>
        /// <param name="AuditRemark">审核备注</param>
        /// <param name="user">用户信息</param>
        /// <returns></returns>
        [TransactionCallHandler]
        public virtual bool AuditAssistModule(int AId, int AuditStatus, string AuditRemark, UserInfo user)
        {
            bool flag = false;
            var model = GetAssistModule(AId);
            if (model != null)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Assist_ViewModel.AuditStatus),AuditStatus },
                    {nameof(RB_Assist_ViewModel.Remark),AuditRemark },
                };
                flag = assistRepository.Update(fileds, new WhereHelper(nameof(RB_Assist_ViewModel.AId), AId));
                AccountStatusEnum statusEnum = (AccountStatusEnum)AuditStatus;
                if (statusEnum == AccountStatusEnum.Pass && flag)
                {
                    flag = accountModule.SetAccountModule(new RB_Account_ViewModel()
                    {
                        Account = model.AssistTel,
                        Password = Common.DES.Encrypt(Common.Config.DefaultPwd),
                        AccountType = AccountTypeEnum.Assist,
                        AccountId = model.AId,
                        CreateBy = user.Id,
                        UpdateBy = user.Id,
                        CreateTime = DateTime.Now,
                        UpdateTime = DateTime.Now,
                        Group_Id = model.Group_Id,
                        School_Id = model.School_Id,
                    });
                }
            }
            return flag;
        }
    }
}
