﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.User;
using Edu.Repository.User;
using System.Collections.Generic;
using System.Linq;
using VT.FW.DB;

namespace Edu.Module.User
{
    /// <summary>
    /// 集团处理类
    /// </summary>
    public class GroupModule
    {
        /// <summary>
        /// 集团仓储对象
        /// </summary>
        private readonly RB_GroupRepository groupRepository = new RB_GroupRepository();

        /// <summary>
        /// 获取集团列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Group_ViewModel> GetGroupListModule(RB_Group_ViewModel query)
        {
            return groupRepository.GetGroupListRepository(query);
        }

        /// <summary>
        /// 获取集团分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Group_ViewModel> GetGroupPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Group_ViewModel query)
        {
            return groupRepository.GetGroupPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 获取集团实体类
        /// </summary>
        /// <param name="GId"></param>
        /// <returns></returns>
        public RB_Group_ViewModel GetGroupEntityModule(int GId)
        {
            return GetGroupListModule(new RB_Group_ViewModel() { GId = GId })?.FirstOrDefault() ?? new RB_Group_ViewModel();
        }

        /// <summary>
        /// 新增修改集团
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public virtual bool SetGroupModule(RB_Group_ViewModel model)
        {
            bool flag;
            if (model.GId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Group_ViewModel.GroupName),model.GroupName.Trim() },
                    {nameof(RB_Group_ViewModel.Domain),model.Domain.Trim() },
                    {nameof(RB_Group_ViewModel.LinkMan),model.LinkMan.Trim() },
                    {nameof(RB_Group_ViewModel.MobilePhone),model.MobilePhone.Trim() },
                    {nameof(RB_Group_ViewModel.Tel),model.Tel.Trim() },
                    {nameof(RB_Group_ViewModel.Address),model.Address },
                    {nameof(RB_Group_ViewModel.Remarks),model.Remarks },
                    {nameof(RB_Group_ViewModel.Logo),model.Logo },
                    {nameof(RB_Group_ViewModel.UpdateBy),model.UpdateBy },
                    {nameof(RB_Group_ViewModel.UpdateTime),model.UpdateTime },
                };
                flag = groupRepository.Update(fileds, new WhereHelper(nameof(RB_Group_ViewModel.GId), model.GId));
            }
            else
            {
                var newId = groupRepository.Insert(model);
                model.GId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 判断集团是否存在
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public bool ExistsGroupModule(RB_Group_ViewModel query)
        {
            List<WhereHelper> wheres = new List<WhereHelper>()
            {
                new WhereHelper(nameof(RB_Group_ViewModel.GroupName),query.GroupName.Trim())
            };
            if (query.GId > 0)
            {
                wheres.Add(new WhereHelper(nameof(RB_Group_ViewModel.GId), query.GId, OperatorEnum.NotEqual));
            }
            return groupRepository.Exists(wheres);
        }

        /// <summary>
        /// 删除集团
        /// </summary>
        /// <param name="GId">集团编号</param>
        /// <returns></returns>
        public virtual bool RemoveGroupModule(object GId)
        {
            bool flag;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Group_ViewModel.Status),(int)DateStateEnum.Delete },
            };
            flag = groupRepository.Update(fileds, new WhereHelper(nameof(RB_Group_ViewModel.GId), GId));
            return flag;
        }
    }
}