﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.User;
using Edu.Repository.User;
using System.Collections.Generic;
using VT.FW.DB;

namespace Edu.Module.User
{
    /// <summary>
    /// 管理者处理类
    /// </summary>
    public class ManagerModule
    {
        /// <summary>
        /// 管理者仓储层对象
        /// </summary>
        private readonly RB_ManagerRepository managerRepository = new RB_ManagerRepository();

        /// <summary>
        /// 获取管理者列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Manager_ViewModel> GetManagerListModule(RB_Manager_ViewModel query)
        {
            return managerRepository.GetManagerListRepository(query);
        }

        /// <summary>
        /// 获取管理者分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Manager_ViewModel> GetManagerPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Manager_ViewModel query)
        {
            return managerRepository.GetManagerPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 新增修改管理者
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetManagerModule(RB_Manager_ViewModel model)
        {
            bool flag;
            if (model.MId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Manager_ViewModel.MName),model.MName.Trim()},
                    { nameof(RB_Manager_ViewModel.MTel),model.MTel.Trim()},
                    { nameof(RB_Manager_ViewModel.MHead),model.MHead },
                    { nameof(RB_Manager_ViewModel.UpdateTime),model.UpdateTime },
                };
                flag = managerRepository.Update(fileds, new WhereHelper(nameof(RB_Manager_ViewModel.MId), model.MId));
            }
            else
            {
                var newId = managerRepository.Insert(model);
                model.MId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据编号获取管理者实体
        /// </summary>
        /// <param name="MId"></param>
        /// <returns></returns>
        public RB_Manager_ViewModel GetManagerModule(object MId)
        {
            return managerRepository.GetEntity<RB_Manager_ViewModel>(MId);
        }

        /// <summary>
        /// 删除管理者
        /// </summary>
        /// <param name="MId"></param>
        /// <returns></returns>
        public bool RemoveManagerModule(int MId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Manager_ViewModel.Status), (int)DateStateEnum.Delete}
            };
            bool flag = managerRepository.Update(fileds, new WhereHelper(nameof(RB_Manager_ViewModel.MId), MId));
            return flag;
        }
    }
}