﻿using System;
using VT.FW.DB;

namespace Edu.Repository
{
    /// <summary>
    /// 仓储层基类
    /// </summary>
    /// <typeparam name="T">约束实体</typeparam>
    public class BaseRepository<T> : RepositoryBase<T> where T : class
    {
        /// <summary>
        /// 数据库连接Key
        /// </summary>
        public string ConnKey { get; set; }

        public BaseRepository()
        {
            string connKey;
            try
            {
                var classAttribute = (DBAttribute)Attribute.GetCustomAttribute(typeof(T), typeof(DBAttribute));
                connKey = classAttribute.ConnectionName ?? "DefaultConnection";
            }
            catch (Exception ex)
            {
                throw ex;
            }
            ConnKey = connKey ?? throw new ArgumentNullException(nameof(connKey));
        }

        public string _ConnectionStr;
        /// <summary>
        /// 链接字符串
        /// </summary>
        public override string ConnectionStr
        {
            get
            {
                _ConnectionStr =Common.Config.GetConnectionString(ConnKey);
                return _ConnectionStr;
            }
            set
            {
                _ConnectionStr = value;
            }
        }

        public string _ProviderName;
        /// <summary>
        /// 提供程序名称
        /// </summary>
        public override string ProviderName
        {
            get
            {
                _ProviderName = "MySql.Data.MySqlClient";
                return _ProviderName;
            }
            set
            {
                _ProviderName = value;
            }
        }
    }
}
