﻿using Edu.Model.ViewModel.Course;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.Course
{
    /// <summary>
    /// 课程仓储层
    /// </summary>
    public class RB_CourseRepository : BaseRepository<Model.Entity.Course.RB_Course>
    {
        /// <summary>
        /// 获取课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_ViewModel> GetCourseListRepository(RB_Course_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Course 
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_ViewModel.Group_Id), query.Group_Id);
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_ViewModel.School_Id), query.School_Id);
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.CourseName))
                {
                    builder.AppendFormat(" AND {0} LIKE @CourseName ", nameof(RB_Course_ViewModel.CourseName));
                    parameters.Add("CourseName", "%" + query.CourseName.Trim() + "%");
                }
                if (query.CateId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_ViewModel.CateId), query.CateId);
                }
            }
            return Get<RB_Course_ViewModel>(builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取课程分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_ViewModel> GetCoursePageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Course_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Course 
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_ViewModel.Group_Id), query.Group_Id);
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_ViewModel.School_Id), query.School_Id);
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.CourseName))
                {
                    builder.AppendFormat(" AND {0} LIKE @CourseName ", nameof(RB_Course_ViewModel.CourseName));
                    parameters.Add("CourseName", "%" + query.CourseName.Trim() + "%");
                }
                if (query.CateId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_ViewModel.CateId), query.CateId);
                }
            }
            return GetPage<RB_Course_ViewModel>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}
