﻿using Edu.Model.ViewModel.Course;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.Course
{
    /// <summary>
    /// 课程讨论仓储层
    /// </summary>
    public class RB_Course_DiscussRepository : BaseRepository<Model.Entity.Course.RB_Course_Discuss>
    {
        /// <summary>
        /// 获取课程讨论分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Discuss_ViewModel> GetDiscussPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Course_Discuss_ViewModel query)
        {
            StringBuilder builder = new StringBuilder();
            DynamicParameters parameters = new DynamicParameters();
            builder.AppendFormat(@" 
SELECT * 
FROM rb_course_discuss
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Discuss_ViewModel.Group_Id), query.Group_Id);
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Discuss_ViewModel.School_Id), query.School_Id);
            if (query.CourseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Discuss_ViewModel.CourseId), query.CourseId);
            }
            if (!string.IsNullOrWhiteSpace(query.DiscussTitle))
            {
                builder.AppendFormat(" AND {0} LIKE @DiscussTitle ", nameof(RB_Course_Discuss_ViewModel.DiscussTitle));
                parameters.Add("DiscussTitle", "%" + query.DiscussTitle.Trim() + "%");
            }
            if (query.DiscussId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Discuss_ViewModel.DiscussId), query.DiscussId);
            }
            return GetPage<RB_Course_Discuss_ViewModel>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}
