﻿using Edu.Model.ViewModel.Course;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.Course
{
    /// <summary>
    /// 课程资料仓储层
    /// </summary>
    public class RB_Course_SourceRepository : BaseRepository<Model.Entity.Course.RB_Course_Source>
    {
        /// <summary>
        /// 获取课程资料分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Source_ViewModel> GetSourcePageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Course_Source_ViewModel query)
        {
            StringBuilder builder = new StringBuilder();
            var parameters = new DynamicParameters();
            builder.AppendFormat(@"
SELECT * 
FROM rb_course_source
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Source_ViewModel.Group_Id), query.Group_Id);
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Source_ViewModel.School_Id), query.School_Id);
            if (query.CourseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Source_ViewModel.CourseId), query.CourseId);
            }
            if (!string.IsNullOrWhiteSpace(query.SourceName))
            {
                builder.AppendFormat(" AND {0} LIKE @SourceName ", nameof(RB_Course_Source_ViewModel.SourceName));
                parameters.Add("SourceName", "%" + query.SourceName.Trim() + "%");
            }
            return GetPage<RB_Course_Source_ViewModel>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}