﻿using Edu.Model.ViewModel.System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.System
{
    /// <summary>
    /// 地区仓储层
    /// </summary>
    public class RB_DestinationRepository:BaseRepository<Model.Entity.System.RB_Destination>
    {
        /// <summary>
        /// 获取所有的地区数据列表
        /// </summary>
        /// <returns></returns>
        public List<RB_Destination_ViewModel> GetDestinationListRepository(RB_Destination_ViewModel query)
        {
            StringBuilder sb = new StringBuilder();
            var parameters = new DynamicParameters();
            sb.AppendFormat("SELECT * FROM rb_destination WHERE 1=1 ");
            sb.AppendFormat(" AND {0}={1} ", nameof(RB_Destination_ViewModel.Status), (int)Common.Enum.DateStateEnum.Normal);
            if (query != null)
            {
                if (query.CodeLevel > 0)
                {
                    sb.AppendFormat(" AND {0}={1}", nameof(RB_Destination_ViewModel.CodeLevel),query.CodeLevel);
                }
                if (query.ParentID > 0)
                {
                    sb.AppendFormat(" AND {0}={1} ", nameof(RB_Destination_ViewModel.ParentID), query.ParentID);
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    sb.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_Destination_ViewModel.Name));
                    parameters.Add("Name", "%" + query.Name.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.NameStr))
                {
                    sb.AppendFormat(" AND {0} in({1})", nameof(RB_Destination_ViewModel.Name), query.NameStr);
                }
                if (query.ID > 0)
                {
                    sb.AppendFormat(" AND {0} in({1})", nameof(RB_Destination_ViewModel.ID), query.ID);
                }
                if (!string.IsNullOrWhiteSpace(query.Ids))
                {
                    sb.AppendFormat(" AND {0} in({1})", nameof(RB_Destination_ViewModel.ID), query.Ids);
                }
            }
            return Get<RB_Destination_ViewModel>(sb.ToString(), parameters).ToList();
        }
    }
}