﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.System
{
    /// <summary>
    /// 系统角色仓储类
    /// </summary>
    public class RB_RoleRepository : BaseRepository<Model.Entity.System.RB_Role>
    {
        /// <summary>
        /// 获取角色列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Role_ViewModel> GetRoleListRepository(RB_Role_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_role
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Role_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Role_ViewModel.Group_Id), query.Group_Id);
                }
                if (query.School_Id > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Role_ViewModel.School_Id), query.School_Id);
                }
                if (query.RoleId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Role_ViewModel.RoleId), query.RoleId);
                }
                if (!string.IsNullOrWhiteSpace(query.RoleName))
                {
                    builder.AppendFormat(" AND {0} LIKE @RoleName ", nameof(RB_Role_ViewModel.RoleName));
                    parameters.Add("RoleName", "%" + query.RoleName.Trim() + "%");
                }
            }
            return Get<RB_Role_ViewModel>(builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取角色分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Role_ViewModel> GetRolePageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Role_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_role
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Role_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Role_ViewModel.Group_Id), query.Group_Id);
                }
                if (query.School_Id > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Role_ViewModel.School_Id), query.School_Id);
                }
                if (query.RoleId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Role_ViewModel.RoleId), query.RoleId);
                }
                if (!string.IsNullOrWhiteSpace(query.RoleName))
                {
                    builder.AppendFormat(" AND {0} LIKE @RoleName ", nameof(RB_Role_ViewModel.RoleName));
                    parameters.Add("RoleName", "%" + query.RoleName.Trim() + "%");
                }
            }
            return GetPage<RB_Role_ViewModel>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    
    }
}
