﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.User;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.User
{
    /// <summary>
    /// 账号仓储层
    /// </summary>
    public class RB_AccountRepository : BaseRepository<Model.Entity.User.RB_Account>
    {
        /// <summary>
        /// 获取账号列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Account_ViewModel> GetAccountListRepository(RB_Account_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM rb_account AS A 
WHERE 1=1 
");
            builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Account_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.Account))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @Account ", nameof(RB_Account_ViewModel.Account));
                    parameters.Add("Account", "%" + query.Account.Trim() + "%");
                }
                if (query.AccountType > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Account_ViewModel.AccountType),query.AccountType);
                }
                if (query.School_Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Account_ViewModel.School_Id), query.School_Id);
                }
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Account_ViewModel.Group_Id), query.Group_Id);
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Account_ViewModel.Id), query.Id);
                }
            }
            return Get<RB_Account_ViewModel>(builder.ToString(),parameters).ToList();
        }

        /// <summary>
        /// 获取账号分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Account_ViewModel> GetAccountPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Account_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM rb_account AS A 
WHERE 1=1 
");
            builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Account_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.Account))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @Account ", nameof(RB_Account_ViewModel.Account));
                    parameters.Add("Account", "%" + query.Account.Trim() + "%");
                }
                if (query.AccountType > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Account_ViewModel.AccountType), query.AccountType);
                }
                if (query.School_Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Account_ViewModel.School_Id), query.School_Id);
                }
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Account_ViewModel.Group_Id), query.Group_Id);
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Account_ViewModel.Id), query.Id);
                }
            }
            return GetPage<RB_Account_ViewModel>(pageIndex,pageSize,out rowsCount,builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取账号列表扩展列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Account_ViewModel> GetAccountListExtRepository(RB_Account_ViewModel query)
        {
            StringBuilder where = new StringBuilder();
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.Account))
                {
                    where.AppendFormat(" AND A.{0}='{1}' ", nameof(RB_Account_ViewModel.Account), query.Account.Trim());
                }
                if (query.AccountType > 0)
                {
                    where.AppendFormat(" AND A.{0}={1} ", nameof(RB_Account_ViewModel.AccountType), (int)query.AccountType);
                }
                if (query.Id > 0)
                {
                    where.AppendFormat(" AND A.{0}={1} ", nameof(RB_Account_ViewModel.Id), query.Id);
                }
            }

            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,IFNULL(G.GroupName,'') AS GroupName,IFNULL(s.SName,'') AS SchoolName,IFNULL(G.Logo,'') AS GroupLogo
FROM 
(
		SELECT A.*,IFNULL(B.MName,'') AS AccountName,B.MHead AS UserIcon
		FROM rb_account AS A INNER JOIN rb_manager AS B ON A.AccountId=B.MId AND A.AccountType=1
		WHERE 1=1 {0}
		UNION ALL
		SELECT A.*,IFNULL(B.TeacherName,'') AS AccountName,B.TeacherIcon AS UserIcon
		FROM rb_account AS A INNER JOIN rb_teacher AS B ON A.AccountId=B.TId AND A.AccountType=2
		WHERE 1=1  {0}
		UNION ALL
		SELECT A.*,IFNULL(B.AssistName,'') AS AccountName,B.AssistIcon AS UserIcon
		FROM rb_account AS A INNER JOIN rb_assist AS B ON A.AccountId=B.AId AND A.AccountType=3
		WHERE 1=1 {0}
		UNION ALL
		SELECT A.*,IFNULL(B.StuName,'') AS AccountName,B.StuIcon AS UserIcon
		FROM rb_account AS A INNER JOIN rb_student AS B ON A.AccountId=B.StuId AND A.AccountType=4
		WHERE 1=1  {0}
) AS A LEFT JOIN rb_group AS g ON A.Group_Id=g.GId
       LEFT JOIN rb_school AS s ON A.School_Id=s.SId
", where.ToString());
            var list = Get<RB_Account_ViewModel>(builder.ToString()).ToList();
            return list;
        }
    }
}