﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.User;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.User
{
    /// <summary>
    /// 集团仓储层
    /// </summary>
    public class RB_GroupRepository : BaseRepository<Model.Entity.User.RB_Group>
    {
        /// <summary>
        /// 获取集团列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Group_ViewModel> GetGroupListRepository(RB_Group_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_group 
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Group_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.GroupName))
                {
                    builder.AppendFormat(" AND {0} LIKE @GroupName ", nameof(RB_Group_ViewModel.GroupName));
                    parameters.Add("GroupName", "%" + query.GroupName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.LinkMan))
                {
                    builder.AppendFormat(" AND {0} LIKE @LinkMan ", nameof(RB_Group_ViewModel.LinkMan));
                    parameters.Add("LinkMan", "%" + query.LinkMan.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.MobilePhone))
                {
                    builder.AppendFormat(" AND {0} LIKE @MobilePhone ", nameof(RB_Group_ViewModel.MobilePhone));
                    parameters.Add("MobilePhone", "%" + query.MobilePhone.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.Tel))
                {
                    builder.AppendFormat(" AND {0} LIKE @Tel ", nameof(RB_Group_ViewModel.Tel));
                    parameters.Add("Tel", "%" + query.Tel.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.Remarks))
                {
                    builder.AppendFormat(" AND {0} LIKE @Remarks ", nameof(RB_Group_ViewModel.Remarks));
                    parameters.Add("Remarks", "%" + query.Remarks.Trim() + "%");
                }
                if (query.GId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Group_ViewModel.GId),query.GId);
                }
            }
            return Get<RB_Group_ViewModel>(builder.ToString(),parameters).ToList();
        }

        /// <summary>
        /// 获取集团分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Group_ViewModel> GetGroupPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Group_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_group 
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Group_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.GroupName))
                {
                    builder.AppendFormat(" AND {0} LIKE @GroupName ", nameof(RB_Group_ViewModel.GroupName));
                    parameters.Add("GroupName", "%" + query.GroupName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.LinkMan))
                {
                    builder.AppendFormat(" AND {0} LIKE @LinkMan ", nameof(RB_Group_ViewModel.LinkMan));
                    parameters.Add("LinkMan", "%" + query.LinkMan.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.MobilePhone))
                {
                    builder.AppendFormat(" AND {0} LIKE @MobilePhone ", nameof(RB_Group_ViewModel.MobilePhone));
                    parameters.Add("MobilePhone", "%" + query.MobilePhone.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.Tel))
                {
                    builder.AppendFormat(" AND {0} LIKE @Tel ", nameof(RB_Group_ViewModel.Tel));
                    parameters.Add("Tel", "%" + query.Tel.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.Remarks))
                {
                    builder.AppendFormat(" AND {0} LIKE @Remarks ", nameof(RB_Group_ViewModel.Remarks));
                    parameters.Add("Remarks", "%" + query.Remarks.Trim() + "%");
                }
                if (query.GId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Group_ViewModel.GId), query.GId);
                }
            }
            return GetPage<RB_Group_ViewModel>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}
