﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.User;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.User
{
    /// <summary>
    /// 管理者仓储层
    /// </summary>
    public class RB_ManagerRepository : BaseRepository<Model.Entity.User.RB_Manager>
    {
        /// <summary>
        /// 获取管理者列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Manager_ViewModel> GetManagerListRepository(RB_Manager_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM rb_manager AS A 
WHERE 1=1 
");
            builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Manager_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.MName))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @MName ", nameof(RB_Manager_ViewModel.MName));
                    parameters.Add("MName", "%" + query.MName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.MTel))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @MTel ", nameof(RB_Manager_ViewModel.MTel));
                    parameters.Add("MTel", "%" + query.MTel.Trim() + "%");
                }
                if (query.School_Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Manager_ViewModel.School_Id), query.School_Id);
                }
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Manager_ViewModel.Group_Id), query.Group_Id);
                }
                if (query.MId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Manager_ViewModel.MId), query.MId);
                }
            }
            return Get<RB_Manager_ViewModel>(builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取管理者分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Manager_ViewModel> GetManagerPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Manager_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM rb_manager AS A 
WHERE 1=1 
");
            builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Manager_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.MName))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @MName ", nameof(RB_Manager_ViewModel.MName));
                    parameters.Add("MName", "%" + query.MName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.MTel))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @MTel ", nameof(RB_Manager_ViewModel.MTel));
                    parameters.Add("MTel", "%" + query.MTel.Trim() + "%");
                }
                if (query.School_Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Manager_ViewModel.School_Id), query.School_Id);
                }
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Manager_ViewModel.Group_Id), query.Group_Id);
                }
                if (query.MId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Manager_ViewModel.MId), query.MId);
                }
            }
            return GetPage<RB_Manager_ViewModel>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}