﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.User;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.User
{
    /// <summary>
    /// 讲师仓储层
    /// </summary>
    public class RB_TeacherRepository : BaseRepository<Model.Entity.User.RB_Teacher>
    {
        /// <summary>
        /// 获取讲师列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Teacher_ViewModel> GetTeacherListRepository(RB_Teacher_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT t.*,g.GroupName,s.SName 
FROM rb_teacher AS t LEFT JOIN rb_group AS g ON t.Group_Id=g.GId
     LEFT JOIN rb_school AS s ON t.School_Id=s.SId
WHERE 1=1 
");
            builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Teacher_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Teacher_ViewModel.Group_Id), query.Group_Id);
                }
                if (query.School_Id > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Teacher_ViewModel.School_Id), query.School_Id);
                }
                if (!string.IsNullOrWhiteSpace(query.TeacherName))
                {
                    builder.AppendFormat(" AND t.{0} LIKE @TeacherName ", nameof(RB_Teacher_ViewModel.TeacherName));
                    parameters.Add("TeacherName", "%" + query.TeacherName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.TeacherTel))
                {
                    builder.AppendFormat(" AND t.{0} LIKE @TeacherTel ", nameof(RB_Teacher_ViewModel.TeacherTel));
                    parameters.Add("TeacherTel", "%" + query.TeacherTel.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.TeacherSay))
                {
                    builder.AppendFormat(" AND t.{0} LIKE @TeacherSay ", nameof(RB_Teacher_ViewModel.TeacherSay));
                    parameters.Add("TeacherSay", "%" + query.TeacherSay.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.TeacherIntro))
                {
                    builder.AppendFormat(" AND t.{0} LIKE @TeacherIntro ", nameof(RB_Teacher_ViewModel.TeacherIntro));
                    parameters.Add("TeacherIntro", "%" + query.TeacherIntro.Trim() + "%");
                }

                if (query.TId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Teacher_ViewModel.TId), query.TId);
                }
            }
            return Get<RB_Teacher_ViewModel>(builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取讲师分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Teacher_ViewModel> GetTeacherPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Teacher_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT t.*,g.GroupName,s.SName 
FROM rb_teacher AS t LEFT JOIN rb_group AS g ON t.Group_Id=g.GId
     LEFT JOIN rb_school AS s ON t.School_Id=s.SId
WHERE 1=1 
");
            builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Teacher_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Teacher_ViewModel.Group_Id), query.Group_Id);
                }
                if (query.School_Id > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Teacher_ViewModel.School_Id), query.School_Id);
                }
                if (!string.IsNullOrWhiteSpace(query.TeacherName))
                {
                    builder.AppendFormat(" AND t.{0} LIKE @TeacherName ", nameof(RB_Teacher_ViewModel.TeacherName));
                    parameters.Add("TeacherName", "%" + query.TeacherName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.TeacherTel))
                {
                    builder.AppendFormat(" AND t.{0} LIKE @TeacherTel ", nameof(RB_Teacher_ViewModel.TeacherTel));
                    parameters.Add("TeacherTel", "%" + query.TeacherTel.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.TeacherSay))
                {
                    builder.AppendFormat(" AND t.{0} LIKE @TeacherSay ", nameof(RB_Teacher_ViewModel.TeacherSay));
                    parameters.Add("TeacherSay", "%" + query.TeacherSay.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.TeacherIntro))
                {
                    builder.AppendFormat(" AND t.{0} LIKE @TeacherIntro ", nameof(RB_Teacher_ViewModel.TeacherIntro));
                    parameters.Add("TeacherIntro", "%" + query.TeacherIntro.Trim() + "%");
                }

                if (query.TId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Teacher_ViewModel.TId), query.TId);
                }
            }
            return GetPage<RB_Teacher_ViewModel>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}