﻿using Edu.Common;
using Edu.Common.API;
using Edu.Common.Plugin;
using Edu.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Edu.Model.CacheModel;
using Edu.Cache.User;

namespace Edu.WebApi.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiFilter]
    [EnableCors("AllowCors")]
    public class BaseController : ControllerBase
    {

        /// <summary>
        /// 整理前端传递的post参数
        /// </summary>
        /// <param name="requestMsg"></param>
        /// <returns></returns>
        public RequestParm RequestParm
        {
            get
            {
                var requestParm = new RequestParm();
                #region 读取post参数
                var requestMsg = Request.HttpContext.Items[GlobalKey.UserPostInfo];
                if (requestMsg != null)
                {
                    requestParm = JsonConvert.DeserializeObject<RequestParm>(requestMsg.ToString());
                    if (Request.HttpContext.Items[GlobalKey.TokenUserInfo] != null)
                    {
                        JObject parms = JObject.Parse(Request.HttpContext.Items[GlobalKey.TokenUserInfo].ToString());
                        requestParm.Uid = parms.GetStringValue("Uid");
                    }
                }
                #endregion
                //根据token 获取uid
                return requestParm;
            }
        }

        /// <summary>
        /// 获取参数
        /// </summary>
        public JObject ParmJObj
        {
            get
            {
                if (this.RequestParm != null && this.RequestParm.Msg != null)
                {
                    return JObject.Parse(this.RequestParm.Msg.ToString());
                }
                return new JObject();
            }
        }

        /// <summary>
        /// 用户缓存
        /// </summary>
        public UserInfo UserInfo
        {
            get
            {
                var parm = this.RequestParm;
                UserInfo userInfo = UserReidsCache.GetUserLoginInfo(parm.Uid);
                return userInfo;
            }
        }
    }
}