﻿using System;
using Edu.AOP;
using Edu.Cache.User;
using Edu.Common.API;
using Edu.Common.Plugin;
using Edu.Model.ViewModel.User;
using Edu.Module.User;
using Edu.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;

namespace Edu.WebApi.Controllers.User
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class UserController : BaseController
    {
        /// <summary>
        /// 助教处理类对象
        /// </summary>
        private readonly AssistModule assistModule = AOPHelper.CreateAOPObject<AssistModule>();

        /// <summary>
        /// 集团处理类对象
        /// </summary>
        private readonly GroupModule groupModule = AOPHelper.CreateAOPObject<GroupModule>();

        /// <summary>
        /// 学校处理类对象
        /// </summary>
        private readonly SchoolModule schoolModule = AOPHelper.CreateAOPObject<SchoolModule>();

        /// <summary>
        /// 学生处理类对象
        /// </summary>
        private readonly StudentModule studentModule = AOPHelper.CreateAOPObject<StudentModule>();

        /// <summary>
        /// 讲师处理类对象
        /// </summary>
        private readonly TeacherModule teacherModule = AOPHelper.CreateAOPObject<TeacherModule>();

        /// <summary>
        /// 系统管理人员处理类对象
        /// </summary>
        private readonly ManagerModule managerModule = AOPHelper.CreateAOPObject<ManagerModule>();

        #region 集团管理

        /// <summary>
        /// 获取集团列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGroupList()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Group_ViewModel>(RequestParm.Msg.ToString());
            var list = groupModule.GetGroupListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取集团分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGroupPageList()
        {
            var pageModel = Common.Plugin.JsonHelper.DeserializeObject<ResultPageModel>(RequestParm.Msg.ToString());
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Group_ViewModel>(RequestParm.Msg.ToString());
            var list = groupModule.GetGroupPageListModule(pageModel.PageIndex, pageModel.PageSize, out long rowsCount, query);
            foreach (var item in list)
            {
                if (item.CreateBy > 0)
                {
                    item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.AccountName ?? "";
                }
                if (item.UpdateBy > 0)
                {
                    item.UpdateByName = UserReidsCache.GetUserLoginInfo(item.UpdateBy)?.AccountName ?? "";
                }
            }
            pageModel.Count = rowsCount;
            pageModel.PageData = list;
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetGroup()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_Group_ViewModel>(RequestParm.Msg.ToString());
            extModel.CreateBy = base.UserInfo.Id;
            extModel.CreateTime = DateTime.Now;
            extModel.UpdateBy = base.UserInfo.Id;
            extModel.UpdateTime = DateTime.Now;
            bool flag = groupModule.SetGroupModule(extModel);
            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }

        /// <summary>
        /// 获取集团列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGroup()
        {
            var GId = base.ParmJObj.GetInt("GId", 0);
            var extModel = groupModule.GetGroupEntityModule(GId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除集团
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveGroup()
        {
            var GId = base.ParmJObj.GetInt("GId", 0);
            var flag = groupModule.RemoveGroupModule(GId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 学校管理

        /// <summary>
        /// 获取学校列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSchoolList()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_School_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            var list = schoolModule.GetSchoolListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取学校分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSchoolPageList()
        {
            var pageModel = Common.Plugin.JsonHelper.DeserializeObject<ResultPageModel>(RequestParm.Msg.ToString());
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_School_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            var list = schoolModule.GetSchoolPageListModule(pageModel.PageIndex, pageModel.PageSize, out long rowsCount, query);
            foreach (var item in list)
            {
                if (item.CreateBy > 0)
                {
                    item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.AccountName ?? "";
                }
                if (item.UpdateBy > 0)
                {
                    item.UpdateByName = UserReidsCache.GetUserLoginInfo(item.UpdateBy)?.AccountName ?? "";
                }
            }
            pageModel.Count = rowsCount;
            pageModel.PageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 添加修改学校
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetSchool()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_School_ViewModel>(RequestParm.Msg.ToString());
            extModel.CreateBy = base.UserInfo.Id;
            extModel.CreateTime = DateTime.Now;
            extModel.UpdateBy = base.UserInfo.Id;
            extModel.UpdateTime = DateTime.Now;
            extModel.Group_Id = base.UserInfo.Group_Id;
            bool flag = schoolModule.SetSchoolModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取学校实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSchool()
        {
            var SId = base.ParmJObj.GetInt("SId", 0);
            var extModel = schoolModule.GetSchoolEntityModule(SId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除学校
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveSchool()
        {
            var SId = base.ParmJObj.GetInt("SId", 0);
            var flag = schoolModule.RemoveSchoolModule(SId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 讲师管理

        /// <summary>
        /// 获取讲师分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetTeacherPageList()
        {
            var pageModel = Common.Plugin.JsonHelper.DeserializeObject<ResultPageModel>(RequestParm.Msg.ToString());
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Teacher_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            //query.School_Id = base.UserInfo.School_Id;
            var list = teacherModule.GetTeacherPageListModule(pageModel.PageIndex, pageModel.PageSize, out long rowsCount, query);
            foreach (var item in list)
            {
                if (item.CreateBy > 0)
                {
                    item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.AccountName ?? "";
                }
                if (item.UpdateBy > 0)
                {
                    item.UpdateByName = UserReidsCache.GetUserLoginInfo(item.UpdateBy)?.AccountName ?? "";
                }
            }
            pageModel.Count = rowsCount;
            pageModel.PageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取讲师列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetTeacherList()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Teacher_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var list = teacherModule.GetTeacherListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 添加修改讲师
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetTeacher()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_Teacher_ViewModel>(RequestParm.Msg.ToString());
            extModel.CreateBy = base.UserInfo.Id;
            extModel.CreateTime = DateTime.Now;
            extModel.UpdateBy = base.UserInfo.Id;
            extModel.UpdateTime = DateTime.Now;
            extModel.AuditStatus = Common.Enum.User.AccountStatusEnum.NoPass;
            extModel.Group_Id = base.UserInfo.Group_Id;
            bool flag = teacherModule.SetTeacherModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取讲师实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetTeacher()
        {
            var TId = base.ParmJObj.GetInt("TId", 0);
            var extModel = teacherModule.GetTeacherModule(TId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除讲师
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveTeacher()
        {
            var TId = base.ParmJObj.GetInt("TId", 0);
            var flag = teacherModule.RemoveTeacherModule(TId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 讲师审核
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult AuditTeacher()
        {
            var TId = base.ParmJObj.GetInt("TId", 0);
            int AuditStatus = base.ParmJObj.GetInt("AuditStatus", 1);
            string AuditRemark = base.ParmJObj.GetStringValue("AuditRemark");
            var flag = teacherModule.AuditTeacherModule(TId, AuditStatus, AuditRemark,base.UserInfo);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 助教管理

        /// <summary>
        /// 获取助教分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAssistPageList()
        {
            var pageModel = Common.Plugin.JsonHelper.DeserializeObject<ResultPageModel>(RequestParm.Msg.ToString());
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Assist_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var list = assistModule.GetAssistPageListModule(pageModel.PageIndex, pageModel.PageSize, out long rowsCount, query);
            foreach (var item in list)
            {
                if (item.CreateBy > 0)
                {
                    item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.AccountName ?? "";
                }
                if (item.UpdateBy > 0)
                {
                    item.UpdateByName = UserReidsCache.GetUserLoginInfo(item.UpdateBy)?.AccountName ?? "";
                }
            }
            pageModel.Count = rowsCount;
            pageModel.PageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取助教列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAssistList()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Assist_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var list = assistModule.GetAssistListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 添加修改助教
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetAssist()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_Assist_ViewModel>(RequestParm.Msg.ToString());
            extModel.CreateBy = base.UserInfo.Id;
            extModel.CreateTime = DateTime.Now;
            extModel.UpdateBy = base.UserInfo.Id;
            extModel.UpdateTime = DateTime.Now;
            extModel.Group_Id = base.UserInfo.Group_Id;
            extModel.AuditStatus = Common.Enum.User.AccountStatusEnum.Normal;
            bool flag = assistModule.SetAssistModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取助教实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAssist()
        {
            var AId = base.ParmJObj.GetInt("AId", 0);
            var extModel = assistModule.GetAssistModule(AId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除讲师
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveAssist()
        {
            var AId = base.ParmJObj.GetInt("AId", 0);
            var flag = assistModule.RemoveAssistModule(AId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 助教审核
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult AuditAssist()
        {
            var AId = base.ParmJObj.GetInt("AId", 0);
            int AuditStatus = base.ParmJObj.GetInt("AuditStatus", 1);
            string AuditRemark = base.ParmJObj.GetStringValue("AuditRemark");
            var flag = assistModule.AuditAssistModule(AId, AuditStatus, AuditRemark, base.UserInfo);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 学生管理

        /// <summary>
        /// 获取学生分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetStudentPageList()
        {
            var pageModel = Common.Plugin.JsonHelper.DeserializeObject<ResultPageModel>(RequestParm.Msg.ToString());
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Student_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var list = studentModule.GetStudentPageListModule(pageModel.PageIndex, pageModel.PageSize, out long rowsCount, query);
            foreach (var item in list)
            {
                if (item.CreateBy > 0)
                {
                    item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.AccountName ?? "";
                }
                if (item.UpdateBy > 0)
                {
                    item.UpdateByName = UserReidsCache.GetUserLoginInfo(item.UpdateBy)?.AccountName ?? "";
                }
            }
            pageModel.Count = rowsCount;
            pageModel.PageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取学生列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetStudentList()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Student_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var list = studentModule.GetStudentListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 添加修改学生
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetStudent()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_Student_ViewModel>(RequestParm.Msg.ToString());
            extModel.CreateBy = base.UserInfo.Id;
            extModel.CreateTime = DateTime.Now;
            extModel.UpdateBy = base.UserInfo.Id;
            extModel.UpdateTime = DateTime.Now;
            extModel.Group_Id = base.UserInfo.Group_Id;
            extModel.IsDisable = 1;
            bool flag = studentModule.SetStudentModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取学生实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetStudent()
        {
            var StuId = base.ParmJObj.GetInt("StuId", 0);
            var extModel = studentModule.GetStudentModule(StuId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除学生
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveStudent()
        {
            var StuId = base.ParmJObj.GetInt("StuId", 0);
            var flag = studentModule.RemoveStudentModule(StuId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新学生禁用或启用
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult UpdateStudentIsDisable()
        {
            var StuId = base.ParmJObj.GetInt("StuId", 0);
            int IsDisable = base.ParmJObj.GetInt("IsDisable", 0);
            var flag = studentModule.UpdateStudentIsDisableModule(StuId, IsDisable);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 管理者管理

        /// <summary>
        /// 获取系统管理者分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetManagerPageList()
        {
            var pageModel = Common.Plugin.JsonHelper.DeserializeObject<ResultPageModel>(RequestParm.Msg.ToString());
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Manager_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var list = managerModule.GetManagerPageListModule(pageModel.PageIndex, pageModel.PageSize, out long rowsCount, query);
            foreach (var item in list)
            {
                if (item.CreateBy > 0)
                {
                    item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.AccountName ?? "";
                }
                if (item.UpdateBy > 0)
                {
                    item.UpdateByName = UserReidsCache.GetUserLoginInfo(item.UpdateBy)?.AccountName ?? "";
                }
            }
            pageModel.Count = rowsCount;
            pageModel.PageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 系统管理者
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetManagerList()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Manager_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var list = managerModule.GetManagerListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 添加修改管理者
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetManager()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_Manager_ViewModel>(RequestParm.Msg.ToString());
            extModel.CreateBy = base.UserInfo.Id;
            extModel.CreateTime = DateTime.Now;
            extModel.UpdateBy = base.UserInfo.Id;
            extModel.UpdateTime = DateTime.Now;
            extModel.Group_Id = base.UserInfo.Group_Id;
            extModel.School_Id = base.UserInfo.School_Id;
            bool flag = managerModule.SetManagerModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取管理者实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetManager()
        {
            var MId = base.ParmJObj.GetInt("MId", 0);
            var extModel = managerModule.GetManagerModule(MId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除管理者
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveManager()
        {
            var MId = base.ParmJObj.GetInt("MId", 0);
            var flag = managerModule.RemoveManagerModule(MId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion
    }
}