﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common
{
    /// <summary>
    /// 全局Key管理
    /// </summary>
    public class GlobalKey
    {
        #region 系统配置
        /// <summary>
        /// 请求异常
        /// </summary>
        public const string Request_Exception = "Request_Exception";
        /// <summary>
        /// 当前请求model
        /// </summary>
        public const string Current_Assembly_Model = "Current_Assembly_Model";
        /// <summary>
        /// 配置文件缓存前缀
        /// </summary>
        public const string ConfigPrefix = "CONFIG_KEY_";
        /// <summary>
        /// 当前请求Token携带的UserInfo
        /// </summary>
        public const string TokenUserInfo = "TokenUserInfo";

        /// <summary>
        /// 当前请求的post参数
        /// </summary>
        public const string UserPostInfo = "UserPostInfo";
        #endregion

        #region 文件路径
        /// <summary>
        /// OA审批文件路径
        /// </summary>
        public const string AuditFilePath = "/New/Upload/Audit/";
        /// <summary>
        /// 财务审批文件路径
        /// </summary>
        public const string FinanceAuditFilePath = "/New/Upload/FinanceAudit/";
        /// <summary>
        /// 企业云盘文件路径
        /// </summary>
        public const string CloudFilePath = "/New/Upload/Cloud/";
        /// <summary>
        /// 打包下载 临时文件夹
        /// </summary>
        public const string CloudFileTemporaryPath = "/New/TemporaryFile/CloudFileTemporary/";
        /// <summary>
        /// 签证打包下载  临时文件夹
        /// </summary>
        public const string VisaPackageTemporaryPath = "/New/TemporaryFile/VisaWord/";
        /// <summary>
        /// 临时文件夹
        /// </summary>
        public const string TemporaryFilePath = "/New/Upload/Temporary/";
        /// <summary>
        /// 签证二维码
        /// </summary>
        public const string VisaQRCodePath = "/New/TemporaryFile/VisaQRCode/";
        /// <summary>
        /// 用户文件路径
        /// </summary>
        public const string UserFilePath = "/New/Upload/User/";
        /// <summary>
        /// 客户文件路径
        /// </summary>
        public const string CustomerFilePath = "/New/Upload/Customer/";
        /// <summary>
        /// 客户签到图片路径
        /// </summary>
        public const string CustomerSignInPath = "/New/Upload/CustomerSignIn/";
        /// <summary>
        /// B2B用户文件路径
        /// </summary>
        public const string B2BUserFilePath = "/New/Upload/B2BUser/";
        #endregion

        #region 字典Key
        /// <summary>
        /// 系统版本
        /// </summary>
        public const string Dict_Key_App_Version = "App_Version";
        /// <summary>
        /// 客户品牌
        /// </summary>
        public const string Dict_Key_Customer_Brand = "Customer_Brand";
        #region DMC
        /// <summary>
        /// 团期标签
        /// </summary>
        public const string Dict_Key_Travel_Price_Tag = "Travel_Price_Tag";
        #endregion
        #endregion
    }
}
