﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.GuideCar
{
    /// <summary>
    /// 司导-导游实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public  class RB_GuideCar_Guide
    {
        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }


        /// <summary>
        /// 状态0-正常，1-冻结
        /// </summary>
        public int IsEnable { get; set; }

        /// <summary>
        /// 导游名称
        /// </summary>
        public string Name { get; set; }


        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }


        /// <summary>
        /// 头像
        /// </summary>
        public string GuidePhoto { get; set; }


        /// <summary>
        /// 从业年限
        /// </summary>
        public decimal WorkYears { get; set; }

        /// <summary>
        /// 用户评分
        /// </summary>
        public decimal Score { get; set; }

        /// <summary>
        /// 所属站点
        /// </summary>
        public int SiteId { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string Telephone { get; set; }

        /// <summary>
        /// 紧急联系电话
        /// </summary>
        public string EmergencyPhone { get; set; }

        /// <summary>
        /// 简介
        /// </summary>
        public string Introduction { get; set; }
    }
}
