﻿using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using Mall.Repository.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Module.BaseSetUp
{
    public class MallBaseModule
    {
        private RB_MallBaseRepository mallBaseRepository = new RB_MallBaseRepository();

        /// <summary>
        /// 获取小程序列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MallBase_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_MallBase_Extend query)
        {
            return mallBaseRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 根据编号获取实体
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>

        public RB_MallBase GetMallBaseEntity(int ID)
        {
            return mallBaseRepository.GetEntity(ID);
        }


        /// <summary>
        /// 新增/修改基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdate(RB_MallBase model)
        {
            if (model.ID == 0)
            {
                return mallBaseRepository.Insert(model) > 0;
            }
            else
            {
                return mallBaseRepository.Update(model);
            }
        }
    }
}
