﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Education
{

    /// <summary>
    ///  教育-老师动态管理表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class Rb_Education_Dynamic
    {
        /// <summary>
        /// 动态文章id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 文章内容
        /// </summary>
        public string Content
        {
            get;
            set;
        }
        /// <summary>
        /// 文件
        /// </summary>        
        public string Files
        {
            get;
            set;
        }
        /// <summary>
        /// 发布位置经纬度（纬度，经度）
        /// </summary>        
        public string LatAndLong
        {
            get;
            set;
        }
        /// <summary>
        /// 发布位置
        /// </summary>        
        public string Address
        {
            get;
            set;
        }
        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }


        /// <summary>
        /// 教师id
        /// </summary>
        public int UserTeacher { get; set; }

        /// <summary>
        /// 老师对应的用户id
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateTime
        {
            get;
            set;
        }
        /// <summary>
        /// 状态 0：正常，1：删除
        /// </summary>        
        public int Status
        {
            get;
            set;
        }
        /// <summary>
        /// 封面图片
        /// </summary>        
        public string CoverPhoto
        {
            get;
            set;
        }

        /// <summary>
        /// 是否公开1-是，2-关注可见
        /// </summary>
        public int IsOpen { get; set; }
        /// <summary>
        /// 文件类型（1：图片，2：视频,3音频）
        /// </summary>        
        public int? FileType
        {
            get;
            set;
        }

        /// <summary>
        /// 秒数
        /// </summary>
        public int Seconds { get; set; }
    }
}
