﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.User;
using VT.FW.DB;

namespace Mall.Model.Entity.Point
{

    /// <summary>
    /// 点数充值订单
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Point_Order
    {
        public int ID { get; set; }

        /// <summary>
        /// 订单号
        /// </summary>        
        public string OrderNo
        {
            get;
            set;
        }
        /// <summary>
        /// 商户单号
        /// </summary>        
        public string MerchantsNo
        {
            get;
            set;
        }


        /// <summary>
        /// 充值前点数
        /// </summary>
        public int OldPonitNum { get; set; }


        /// <summary>
        /// 充值点数
        /// </summary>
        public int PonitNum { get; set; }


        /// <summary>
        /// 赠送点数
        /// </summary>
        public int GivePoint { get; set; }

        /// <summary>
        /// 实收金额
        /// </summary>        
        public decimal? Income
        {
            get;
            set;
        }


        /// <summary>
        /// 支付类型 枚举  1微信  2支付宝   3银行卡 
        /// </summary>        
        public Common.Enum.Goods.OrderPayTypeEnum? PayWay
        {
            get;
            set;
        }
        /// <summary>
        /// 支付方式   枚举
        /// </summary>        
        public OrderPaymentTypeEnum? PaymentWay
        {
            get;
            set;
        }

        /// <summary>
        /// 用户id
        /// </summary>        
        public int? UserId
        {
            get;
            set;
        }

        /// <summary>
        /// 订单状态  1-代付款，2-已付款
        /// </summary>        
        public int OrderStatus
        {
            get;
            set;
        }

        /// <summary>
        /// 支付时间
        /// </summary>
        public DateTime? PaymentTime { get; set; }


        /// <summary>
        /// 版本来源  0默认商城  1教育
        /// </summary>
        public int? VersionSource { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? State
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }



        /// <summary>
        /// 订单来源（平台）  枚举
        /// </summary>        
        public UserSourceEnum? OrderSource
        {
            get;
            set;
        }
    }
}
