﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Point;
using VT.FW.DB;

namespace Mall.Model.Entity.Point
{

    /// <summary>
    /// 老师课程
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Point_TeacherCourse
    {
        public int ID { get; set; }

        /// <summary>
        /// 课程分类id
        /// </summary>
        public int CourseClassId { get; set; }

        /// <summary>
        /// 老师id
        /// </summary>
        public int TeacherId { get; set; }


        /// <summary>
        /// 学习时间
        /// </summary>
        public DateTime StudyDate { get; set; }


        /// <summary>
        /// 学习开始时间
        /// </summary>
        public string StudyStartDate { get; set; }


        /// <summary>
        /// 学习结束时间
        /// </summary>
        public string StudyEndDate { get; set; }


        /// <summary>
        /// 点数
        /// </summary>
        public int PointNum { get; set; }

        /// <summary>
        /// 课程名称
        /// </summary>
        public string CourseName { get; set; }

        /// <summary>
        /// 最少约课时长
        /// </summary>
        public decimal MinDuration { get; set; }
        /// <summary>
        /// 时长
        /// </summary>
        public decimal StudyDuration { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? State
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }

    }
}
