﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Point;
using Mall.Model.Entity.Point;

namespace Mall.Model.Extend.Point
{
    public class RB_Point_TeacherCourse_Extend : RB_Point_TeacherCourse
    {

        /// <summary>
        /// 分类类型
        /// </summary>
        public CourseClassTypeEnum CourseClassType { get; set; }


        /// <summary>
        /// 上课人数
        /// </summary>
        public StudentNumTypeEnum StudentNumType { get; set; }

        /// <summary>
        /// 是否为公开课0-否，1-是
        /// </summary>
        public int IsPublic { get; set; }


        /// <summary>
        /// 是否免费0-否，1-是
        /// </summary>
        public int IsFree { get; set; }


        /// <summary>
        /// 时长单位
        /// </summary>
        public DurationUnitEnum DurationUnit { get; set; }



        /// <summary>
        /// 学习开始时间
        /// </summary>
        public DateTime StudyStartTime { get; set; }


        /// <summary>
        /// 学习结束时间
        /// </summary>
        public DateTime StudyEndTime { get; set; }


        public string TeacherName { get; set; }


        public string TeacherLogo { get; set; }


        #region 查询时间范围
        /// <summary>
        /// 查询开始时间
        /// </summary>
        public string SelectStartTime { get; set; }


        /// <summary>
        /// 查询结束时间
        /// </summary>
        public string SelectEndTime { get; set; }

        /// <summary>
        /// 订单数
        /// </summary>
        public int OrderNum { get; set; }
        #endregion
    }
}
