﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.Point;

namespace Mall.Repository.Point
{
   public class RB_Member_PointBalanceRepository:BaseRepository<RB_Member_PointBalance>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Member_PointBalance); } }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Member_PointBalance_Extend> GetPointBalanceList(RB_Member_PointBalance_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from RB_Member_PointBalance  where state=0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.UserId > 0)
                {
                    sb.AppendFormat(" and ID={0}", where.UserId);
                }
            }
            return Get<RB_Member_PointBalance_Extend>(sb.ToString()).ToList();
        }




        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Member_PointBalance_Extend> GetPointBalancePageList(int pageIndex, int pageSize, out long rowsCount, RB_Member_PointBalance_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from RB_Member_PointBalance  where 1=1 ");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.UserId > 0)
                {
                    sb.AppendFormat(" and ID={0}", where.UserId);
                }
                if (where.Type > 0) {
                    sb.AppendFormat(" and Type ={0}", (int)where.Type);
                }
                if (where.OrderId > 0) {
                    sb.AppendFormat(" and OrderId ={0}", where.OrderId);
                }
            }
            sb.Append($@" order by Id desc");
            return GetPage<RB_Member_PointBalance_Extend>(pageIndex, pageSize, out rowsCount, sb.ToString()).ToList();
        }
    }
}
