﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Enum.Goods
{
    /// <summary>
    /// 订单支付类型枚举
    /// </summary>
    public enum OrderPaymentTypeEnum
    {
        /// <summary>
        /// 在线支付
        /// </summary>
        [EnumField("在线支付")]
        OnlinePayment = 1,
        /// <summary>
        /// 货到付款
        /// </summary>
        [EnumField("货到付款")]
        OfflinePayment = 2,
        /// <summary>
        /// 余额支付
        /// </summary>
        [EnumField("余额支付")]
        YEPayment = 3,

        /// <summary>
        /// 线下支付
        /// </summary>
        [EnumField("线下支付")]
        OfflinePay =4,

        /// <summary>
        /// 支付定金
        /// </summary>
        [EnumField("支付定金")]
        PayDeposit = 5,
        /// <summary>
        /// 储值卡支付
        /// </summary>
        [EnumField("储值卡支付")]
        PayCards = 7,

        /// <summary>
        /// 点数支付
        /// </summary>
        [EnumField("点数支付")]
        PayPoint = 6,
    }
}
