﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum;
using Mall.Common.Enum.TradePavilion;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 心愿单实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_FirstShop_Wish
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 用户id
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 品牌名称
        /// </summary>
        public string BranchName { get; set; }

        /// <summary>
        /// CarrierName
        /// </summary>
        public string CarrierName { get; set; }

        /// <summary>
        /// 区域
        /// </summary>
        public string Area { get; set; }

        /// <summary>
        /// 心愿详情
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// 名片路径
        /// </summary>
        public string NameCard { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }

    }
}
