﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Education;

namespace Mall.Model.Extend.Education
{
    /// <summary>
    /// 员工视图实体类
    /// </summary>
    public class Employee_ViewModel : RB_Account
    {
        /// <summary>
        /// 员工姓名
        /// </summary>
        public string EmployeeName { get; set; }

        /// <summary>
        /// 集团名称
        /// </summary>
        public string GroupName { get; set; }

        /// <summary>
        /// 学校名称
        /// </summary>
        public string SchoolName { get; set; }

        /// <summary>
        /// 用户头像
        /// </summary>
        public string UserIcon { get; set; }

        /// <summary>
        /// 部门编号
        /// </summary>
        public int Dept_Id { get; set; }

        /// <summary>
        /// 岗位编号
        /// </summary>
        public int Post_Id { get; set; }

        /// <summary>
        /// 部门名称
        /// </summary>
        public string DeptName { get; set; }

        /// <summary>
        /// 岗位名称
        /// </summary>
        public string PostName { get; set; }

        /// <summary>
        /// 岗位编号【查询使用，逗号分隔】
        /// </summary>
        public string QPostIds { get; set; }

        /// <summary>
        /// 部门编号【查询使用，逗号分隔】
        /// </summary>
        public string QDeptIds { get; set; }

        /// <summary>
        /// 人员类型【查询使用，逗号分隔】
        /// </summary>
        public string AccountTypeStr { get; set; }

        /// <summary>
        /// 员工编号【查询使用，逗号分隔】
        /// </summary>
        public string QIds { get; set; }
        /// <summary>
        /// 入职开始时间【查询使用】
        /// </summary>
        public string StartEntryTime { get; set; }
        /// <summary>
        /// 离职开始时间【查询使用】
        /// </summary>
        public string EndEntryTime { get; set; }
        /// <summary>
        /// 离职开始时间【查询使用】
        /// </summary>
        public string StartLeaveTime { get; set; }
        /// <summary>
        /// 离职结束时间【查询使用】
        /// </summary>
        public string EndLeaveTime { get; set; }


        /// <summary>
        /// 生日开始时间【查询使用，2020-01】
        /// </summary>
        public string StartBirthDate { get; set; }

        /// <summary>
        /// 生日结束时间【查询使用，2020-01】
        /// </summary>
        public string EndBirthDate { get; set; }

        /// <summary>
        /// 部门层级
        /// </summary>
        public int DeptTier { get; set; }

        /// <summary>
        /// 性别(0-男，1-女)
        /// </summary>
        public int Sex { get; set; }

        /// <summary>
        /// 出生日期
        /// </summary>
        public DateTime BirthDate { get; set; }

        /// <summary>
        /// 学历
        /// </summary>
        public int Education { get; set; }

        /// <summary>
        /// 入职时间
        /// </summary>
        public DateTime EntryTime { get; set; }

        /// <summary>
        /// 地址
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        /// 在职状态(1-在职，2-离职)
        /// </summary>
        public int IsLeave { get; set; }

        /// <summary>
        /// 在职状态
        /// </summary>
        public int LeaveStatus { get; set; }

        /// <summary>
        /// 离职时间
        /// </summary>
        public DateTime? LeaveTime { get; set; }

        /// <summary>
        /// 是否近7日生日
        /// </summary>
        public int IsBirth { get; set; }

        /// <summary>
        /// 员工电话
        /// </summary>
        public string EmployeeTel { get; set; }

        /// <summary>
        /// 身份证
        /// </summary>
        public string IDCard { get; set; }

        /// <summary>
        /// 行政备注
        /// </summary>
        public string AccountRemark { get; set; }

        /// <summary>
        /// 邮箱
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// 直接主管ids
        /// </summary>
        public string DirectSupervisorIds { get; set; }
    }
}
