﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品关联课程表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_WK_Course_Extend : RB_Goods_WK_Course
    {
        /// <summary>
        /// 商品ids
        /// </summary>
        public string GoodsIds { get; set; }
        /// <summary>
        /// 是否已阅读  1是  2否
        /// </summary>
        public int IsRead { get; set; }
        /// <summary>
        /// 缓存状态
        /// </summary>
        public int FileState { get; set; }
        /// <summary>
        /// 大小
        /// </summary>
        public decimal Size { get; set; }
        /// <summary>
        /// 单位
        /// </summary>
        public string Unit { get; set; }
        /// <summary>
        /// 用户id
        /// </summary>
        public int UserId { get; set; }
    }

    /// <summary>
    /// 课程图片
    /// </summary>
    public class CourseImageModel
    {
        /// <summary>
        /// 排序
        /// </summary>
        public int Sort { get; set; }
        /// <summary>
        /// 存储地址  1腾讯云   2阿里云
        /// </summary>
        public int PathType { get; set; }
        /// <summary>
        /// 图片地址
        /// </summary>
        public string Path { get; set; }
    }
}
