﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;

namespace Mall.Repository.Education
{
    public class RB_Education_BaseInfoRepository : BaseRepository<RB_Education_BaseInfo>
    {
        /// <summary>
        /// 获取教育用户的基础信息
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_BaseInfo_Extend> GetEducationBaseInfo(RB_Education_BaseInfo_Extend query)
        {

            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Education_BaseInfo
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_BaseInfo_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Education_BaseInfo_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_BaseInfo_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_BaseInfo_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_BaseInfo_Extend.UserId), query.UserId);
                }
                if (query.StudentId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_BaseInfo_Extend.StudentId), query.StudentId);
                }
                if (!string.IsNullOrWhiteSpace(query.Ids))
                {
                    builder.AppendFormat($@" AND { nameof(RB_Education_BaseInfo_Extend.UserId)} in ({query.Ids}) ");
                }
            }
            return Get<RB_Education_BaseInfo_Extend>(builder.ToString()).ToList();
        }
    }
}
