﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Finance;

namespace Mall.Repository.Finance
{
    public class RB_Online_Trade_DetailRepository : BaseRepository<RB_Online_Trade_Detail>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Online_Trade_Detail); } }

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_Online_Trade_Detail> GetPageList(int pageIndex, int pageSize, out long count, RB_Online_Trade_Detail model)
        {
            string where = " WHERE 1=1 ";
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.RB_Group_Id) + "={0} ", model.RB_Group_Id);
            }
            if (!string.IsNullOrEmpty(model.Pay_Order))
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.Pay_Order) + " like '%{0}%' ", model.Pay_Order);
            }
            if (!string.IsNullOrEmpty(model.Trade_Order))
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.Trade_Order) + " like '%{0}%' ", model.Trade_Order);
            }
            if (!string.IsNullOrEmpty(model.RefundTrade_Order))
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.RefundTrade_Order) + " like '%{0}%' ", model.RefundTrade_Order);
            }
            if (model.OrderId > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.OrderId) + "={0} ", model.OrderId);
            }
            if (model.FinanceId > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.FinanceId) + "={0} ", model.FinanceId);
            }
            if (model.OrderSource > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.OrderSource) + "={0} ", (int)model.OrderSource);
            }
            if (model.Type > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.Type) + "={0} ", (int)model.Type);
            }
            if (model.Pay_Way > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.Pay_Way) + "={0} ", (int)model.Pay_Way);
            }
            if (model.RefundStatus > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.RefundStatus) + "={0} ", (int)model.RefundStatus);
            }
            if (!string.IsNullOrWhiteSpace(model.Mch_Id))
            {
                where += $@" AND {nameof(RB_Online_Trade_Detail.IsRefund)} like '%{model.Mch_Id}%')";
            }



            return GetPage<RB_Online_Trade_Detail>(pageIndex, pageSize, out count, "select * from " + TableName + " " + where).ToList();
        }

        /// <summary>
        /// 通过条件获取列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_Online_Trade_Detail> GetList(RB_Online_Trade_Detail model)
        {
            string where = " WHERE 1=1 ";
            if (!string.IsNullOrEmpty(model.Pay_Order))
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.Pay_Order) + "='{0}' ", model.Pay_Order);
            }
            if (!string.IsNullOrEmpty(model.Trade_Order))
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.Trade_Order) + "='{0}' ", model.Trade_Order);
            }
            if (!string.IsNullOrEmpty(model.RefundTrade_Order))
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.RefundTrade_Order) + " like '%{0}%' ", model.RefundTrade_Order);
            }
            if (model.OrderId > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.OrderId) + "={0} ", model.OrderId);
            }
            if (model.FinanceId > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.FinanceId) + "={0} ", model.FinanceId);
            }
            if (model.OrderSource > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.OrderSource) + "={0} ", (int)model.OrderSource);
            }
            if (model.Type > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.Type) + "={0} ", (int)model.Type);
            }
            if (model.Pay_Way > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.Pay_Way) + "={0} ", (int)model.Pay_Way);
            }
            if (model.RefundStatus > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.RefundStatus) + "={0} ", (int)model.RefundStatus);
            }
            if (!string.IsNullOrWhiteSpace(model.Mch_Id))
            {
                where += $@" AND {nameof(RB_Online_Trade_Detail.IsRefund)} like '%{model.Mch_Id}%')";
            }
            return Get<RB_Online_Trade_Detail>("select * from " + TableName + " " + where).ToList();
        }




        /// <summary>
        /// 通过条件获取列表
        /// </summary>
        /// <param name="model"></param>
        /// <param name="orderIds">订单号</param>
        /// <returns></returns>
        public List<RB_Online_Trade_Detail> GetList(RB_Online_Trade_Detail model, string orderIds)
        {
            string where = " WHERE 1=1 ";
            if (model.OrderSource > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.OrderSource) + "={0} ", (int)model.OrderSource);
            }
            if (model.Type > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.Type) + "={0} ", (int)model.Type);
            }
            if (model.Pay_Way > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.Pay_Way) + "={0} ", (int)model.Pay_Way);
            }
            if (model.RefundStatus > 0)
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.RefundStatus) + "={0} ", (int)model.RefundStatus);
            }
            if (!string.IsNullOrWhiteSpace(orderIds))
            {
                where += string.Format(" AND " + nameof(RB_Online_Trade_Detail.OrderId) + " in({0}) ", orderIds);
            }
            return Get<RB_Online_Trade_Detail>("select * from " + TableName + " " + where).ToList();
        }

    }
}
