﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;

namespace Mall.Repository.Finance
{
    /// <summary>
    /// 单据交易方式仓储层
    /// </summary>
    public class RB_TradeWayRepository : BaseRepository<RB_TradeWay>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_TradeWay); } }

        /// <summary>
        /// 获取交易方式列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_TradeWay> GetList(RB_TradeWay_Extend model)
        {
            string where = " WHERE 1=1 ";
            where += string.Format(" AND " + nameof(RB_TradeWay.Status) + "={0} ", (int)Common.Enum.DateStateEnum.Normal);
            if (model.FinanceId > 0)
            {
                where += string.Format(" AND " + nameof(RB_TradeWay.FinanceId) + "={0} ", model.FinanceId);
            }
            if (!string.IsNullOrWhiteSpace(model.FrIdStr))
            {
                where += string.Format(" AND " + nameof(RB_TradeWay.FinanceId) + " in({0}) ", model.FrIdStr);
            }
            if (model.Type > 0)
            {
                where += string.Format(" AND " + nameof(RB_TradeWay.Type) + "={0} ", (int)model.Type);
            }
            if (model.AccountId > 0)
            {
                where += string.Format(" AND " + nameof(RB_TradeWay.AccountId) + "={0} ", model.AccountId);
            }
            return Get<RB_TradeWay>("select * from " + TableName + " " + where).ToList();
        }
    }
}
