﻿using Mall.Model.Entity.Reserve;
using Mall.Model.Entity.User;
using Mall.Model.Extend.Reserve;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Reserve
{
    public class RB_Reserve_CouponSelfMotionMemberRepository : BaseRepository<RB_Reserve_CouponSelfMotionMember>
    {
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Reserve_CouponSelfMotionMember); } }

        // <summary>
        /// 表名称
        /// </summary>
        public string UserTableName { get { return nameof(RB_Member_User); } }

        /// <summary>
        /// 获取发放优惠券的人员信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CSelfMotionMember_Extend> GetListRepository(RB_Reserve_CSelfMotionMember_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" SELECT a.*,b.`Name`,b.Photo  FROM {TableName} as a 
LEFT JOIN {UserTableName} as b on a.UserId = b.ID WHERE   a.{nameof(RB_Reserve_CSelfMotionMember_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_CSelfMotionMember_Extend.TenantId)}={query.TenantId}");
                }

                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_CSelfMotionMember_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.SelfMotionId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_CSelfMotionMember_Extend.SelfMotionId)}={query.SelfMotionId}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_CSelfMotionMember_Extend.UserId)}={query.UserId}");
                }

                //if (!string.IsNullOrWhiteSpace(query.PriceIds))
                //{
                //    builder.Append($" AND a.{nameof(RB_Reserve_CSelfMotionMember_Extend.RulesPriceId)} in ({query.PriceIds})");
                //}
            }
            return Get<RB_Reserve_CSelfMotionMember_Extend>(builder.ToString()).ToList();
        }
    }
}
