﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;

namespace Mall.Repository.User
{
    public class RB_Member_DepositBuyRepository : BaseRepository<RB_Member_DepositBuy>
    {
        /// <summary>
        /// 余额充值
        /// </summary>
        public string TableName { get { return nameof(RB_Member_DepositBuy); } }
        /// <summary>
        /// 购买列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_DepositBuy_Extend> GetDepositBuyPageList(int pageIndex, int pageSize, out long rowCount, RB_Member_DepositBuy_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  1=1");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBuy.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBuy.MallBaseId)}={query.MallBaseId}");
                }
                if (query.SendStatus > -1)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBuy.SendStatus)}={query.SendStatus}");
                }
                if (query.Status > -1)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBuy.Status)}={query.Status}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBuy.UserId)}={query.UserId}");
                }
            }
            return GetPage<RB_Member_DepositBuy_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 购买信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_DepositBuy_Extend> GetDepositBuyList(RB_Member_DepositBuy_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE 1=1 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBuy.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBuy.MallBaseId)}={query.MallBaseId}");
                }
                if (query.SendStatus > -1)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBuy.SendStatus)}={query.SendStatus}");
                }
                if (query.Status > -1)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBuy.Status)}={query.Status}");
                }
                if (!string.IsNullOrWhiteSpace(query.Ids))
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBuy.Id)} in({query.Ids})");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBuy.UserId)}={query.UserId}");
                }
                if (query.Id > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBuy.Id)}={query.Id}");
                }
                if (query.IsOver > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBuy.EndTime)}> NOW()");
                }
                // where += $" AND a.{nameof(RB_Member_DiscountCoupon_Extend.EndDate)}<NOW()   AND a.{nameof(RB_Member_DiscountCoupon_Extend.UseState)}=0";
            }
            return Get<RB_Member_DepositBuy_Extend>(builder.ToString()).ToList();
        }
    }
}
