﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Miai;
using Mall.Model.Extend.Miai;
using System.Linq;

namespace Mall.Repository.Miai
{
    /// <summary>
    /// 活动评论仓储层
    /// </summary>
    public class RB_Miai_ActivityDiscussRepository : BaseRepository<RB_Miai_ActivityDiscuss>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Miai_ActivityDiscuss_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Miai_ActivityDiscuss_Extend dmodel)
        {
            string where = $" 1=1 and d.{nameof(RB_Miai_ActivityDiscuss_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and d.{nameof(RB_Miai_ActivityDiscuss_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and d.{nameof(RB_Miai_ActivityDiscuss_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.ActivityId > 0)
            {
                where += $@" and d.{nameof(RB_Miai_ActivityDiscuss_Extend.ActivityId)} ={dmodel.ActivityId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and d.{nameof(RB_Miai_ActivityDiscuss_Extend.UserId)} ={dmodel.UserId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and d.{nameof(RB_Miai_ActivityDiscuss_Extend.Id)} ={dmodel.Id}";
            }
            if (dmodel.ParentId > 0)
            {
                where += $@" and d.{nameof(RB_Miai_ActivityDiscuss_Extend.ParentId)} ={dmodel.ParentId}";
            }
            if (dmodel.ParentId == -1)
            {
                where += $@" and d.{nameof(RB_Miai_ActivityDiscuss_Extend.ParentId)} =0";
            }

            string sql = $@"select d.*,u.Name as CreateByUserName,u.Photo,u1.Name as ReplyUserName,b.Sex,IFNULL(dz.DianZanNum,0) as DianZanNum from RB_Miai_ActivityDiscuss d
left join rb_member_user u on d.UserId = u.Id
left join rb_member_user u1 on d.ReplyUserId = u1.Id
left join rb_miai_baseinfo b on d.UserId =b.UserId
LEFT JOIN (SELECT ActivityDiscussId,COUNT(*) DianZanNum from rb_miai_dianzan where `Status`=0 and ActivityId>0 and ActivityDiscussId>0  GROUP BY ActivityDiscussId) as dz on dz.ActivityDiscussId=d.Id
where {where} order by d.Id desc";
            return GetPage<RB_Miai_ActivityDiscuss_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Miai_ActivityDiscuss_Extend> GetList(RB_Miai_ActivityDiscuss_Extend dmodel)
        {
            string where = $" 1=1 and d.{nameof(RB_Miai_ActivityDiscuss_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and d.{nameof(RB_Miai_ActivityDiscuss_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and d.{nameof(RB_Miai_ActivityDiscuss_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.ActivityId > 0)
            {
                where += $@" and d.{nameof(RB_Miai_ActivityDiscuss_Extend.ActivityId)} ={dmodel.ActivityId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ActivityIds))
            {
                where += $@" and d.{nameof(RB_Miai_ActivityDiscuss_Extend.ActivityId)} in({dmodel.ActivityIds})";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and d.{nameof(RB_Miai_ActivityDiscuss_Extend.UserId)} ={dmodel.UserId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and d.{nameof(RB_Miai_ActivityDiscuss_Extend.Id)} ={dmodel.Id}";
            }
            if (dmodel.ParentId > 0)
            {
                where += $@" and d.{nameof(RB_Miai_ActivityDiscuss_Extend.ParentId)} ={dmodel.ParentId}";
            }
            string orderBy = " order by d.Id asc ";
            if (dmodel.OrderBy == 1)
            {
                orderBy = "  ORDER BY IFNULL(dz.DianZanNum, 0)  desc,d.CreateDate desc";
            }
            string sql = $@"select d.*,IFNULL(dz.DianZanNum,0) as DianZanNum from RB_Miai_ActivityDiscuss as d LEFT JOIN (SELECT ActivityDiscussId,COUNT(*) DianZanNum from rb_miai_dianzan where `Status`=0 and ActivityId>0 and ActivityDiscussId>0  GROUP BY ActivityDiscussId) as dz on dz.ActivityDiscussId=d.Id where {where}  {orderBy}";
            return Get<RB_Miai_ActivityDiscuss_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取子集回复 前几条数据
        /// </summary>
        /// <param name="pidsList"></param>
        /// <param name="number"></param>
        /// <returns></returns>
        public List<RB_Miai_ActivityDiscuss_Extend> GetActivityDiscussChildList(List<int> pidsList, int number)
        {
            int count = pidsList.Count();
            string sql = "";
            if (count == 1)
            {
                //只有一条数据
                sql = $@"select d.*,u.Name as CreateByUserName,u.Photo,u1.Name as ReplyUserName,IFNULL(dz.DianZanNum,0) as DianZanNum from RB_Miai_ActivityDiscuss d
left join rb_member_user u on d.UserId = u.Id
left join rb_member_user u1 on d.ReplyUserId = u1.Id
LEFT JOIN (SELECT ActivityDiscussId,COUNT(*) DianZanNum from rb_miai_dianzan where `Status`=0 and ActivityId>0 and ActivityDiscussId>0  GROUP BY ActivityDiscussId) as dz on dz.ActivityDiscussId=d.Id
where d.Status =0 and d.ParentId ={pidsList.FirstOrDefault()} order by d.Id desc limit {number}";
            }
            else
            {
                for (var i = 0; i < count; i++)
                {
                    if (i == count - 1)
                    {
                        //最后一条
                        sql += $@"(select d.*,u.Name as CreateByUserName,u.Photo,u1.Name as ReplyUserName,IFNULL(dz.DianZanNum,0) as DianZanNum from RB_Miai_ActivityDiscuss d
left join rb_member_user u on d.UserId = u.Id
left join rb_member_user u1 on d.ReplyUserId = u1.Id
LEFT JOIN (SELECT ActivityDiscussId,COUNT(*) DianZanNum from rb_miai_dianzan where `Status`=0 and ActivityId>0 and ActivityDiscussId>0  GROUP BY ActivityDiscussId) as dz on dz.ActivityDiscussId=d.Id
where d.Status =0 and d.ParentId ={pidsList[i]} order by d.Id desc limit {number})";
                    }
                    else
                    {
                        sql += $@"(select d.*,u.Name as CreateByUserName,u.Photo,u1.Name as ReplyUserName,IFNULL(dz.DianZanNum,0) as DianZanNum from RB_Miai_ActivityDiscuss d
left join rb_member_user u on d.UserId = u.Id
left join rb_member_user u1 on d.ReplyUserId = u1.Id
LEFT JOIN (SELECT ActivityDiscussId,COUNT(*) DianZanNum from rb_miai_dianzan where `Status`=0 and ActivityId>0 and ActivityDiscussId>0  GROUP BY ActivityDiscussId) as dz on dz.ActivityDiscussId=d.Id
where d.Status =0 and d.ParentId ={pidsList[i]} order by d.Id desc limit {number})
union 
";
                    }
                }
            }

            return Get<RB_Miai_ActivityDiscuss_Extend>(sql).ToList();

        }

        /// <summary>
        /// 获取回复数量
        /// </summary>
        /// <param name="activityIds"></param>
        /// <returns></returns>
        public List<RB_Miai_ActivityDiscuss_Extend> GetActivityReplyNumList(string activityIds)
        {
            string sql = $@"select ActivityId,count(0) as ReplyNum from RB_Miai_ActivityDiscuss where Status =0 and ActivityId in({activityIds}) group by ActivityId";
            return Get<RB_Miai_ActivityDiscuss_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取评论回复数量
        /// </summary>
        /// <param name="pids"></param>
        /// <returns></returns>
        public List<RB_Miai_ActivityDiscuss_Extend> GetDiscussReplyNumList(string pids)
        {
            string sql = $@"select ParentId,count(0) as ReplyNum from RB_Miai_ActivityDiscuss where Status =0 and ParentId in({pids}) group by ParentId";
            return Get<RB_Miai_ActivityDiscuss_Extend>(sql).ToList();
        }
    }
}
