﻿using Mall.Common.Plugin;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Entity.User;
using Mall.Model.Extend.BaseSetUp;
using Mall.Repository;
using Mall.Repository.BaseSetUp;
using Mall.Repository.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.BaseSetUp
{
    public class MallBaseModule
    {
        private RB_MiniProgramRepository miniProgramRepository = new RB_MiniProgramRepository();
        private RB_MallBaseRepository mallBaseRepository = new RB_MallBaseRepository();
        private RB_LogisticsRepository logisticsRepository = new RB_LogisticsRepository();
        private RB_Logistics_RulesPriceRepository logisticsRulesPriceRepository = new RB_Logistics_RulesPriceRepository();
        private RB_Logistics_RulesRegionRepository logisticsRulesRegionRepository = new RB_Logistics_RulesRegionRepository();
        private RB_Logistics_RulesRepository logisticsRulesRepository = new RB_Logistics_RulesRepository();
        private RB_Logistics_DeliveryRepository deliveryRepository = new RB_Logistics_DeliveryRepository();
        private RB_Logistics_ExpressRepository expressRepository = new RB_Logistics_ExpressRepository();
        private RB_ElectronicSheetRepository electronicSheetRepository = new RB_ElectronicSheetRepository();

        private RB_File_StoreRepository storeRepository = new RB_File_StoreRepository();
        private RB_FreeShippingCategoryRepository freeShippingCategoryRepository = new RB_FreeShippingCategoryRepository();
        private RB_FreeShippingRepository freeShippingRepository = new RB_FreeShippingRepository();

        private RB_MicroShop_BasicsRepository microShopBasicsRepository = new RB_MicroShop_BasicsRepository();

        #region 基础设置
        /// <summary>
        /// 获取小程序列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MallBase_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_MallBase_Extend query)
        {
            return mallBaseRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 获取小程序列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MallBase_Extend> GetListRepository(RB_MallBase_Extend query)
        {
            return mallBaseRepository.GetListRepository(query);
        }


        /// <summary>
        /// 根据编号获取实体
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>

        public RB_MallBase GetMallBaseEntity(int ID)
        {

            return mallBaseRepository.GetEntity(ID);
        }


        /// <summary>
        /// 新增/修改基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateMallBase(RB_MallBase_Extend model)
        {
            bool flag = false;
            var trans = mallBaseRepository.DbTransaction;
            try
            {
                if (model.ID == 0)
                {
                    flag = mallBaseRepository.Insert(model, trans) > 0;
                }
                else
                {
                    flag = mallBaseRepository.Update(model, trans);
                }
                IDictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_MiniProgram.MallName),model.MallName},
                };
                IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                {
                    new WhereHelper (){ FiledName=nameof(RB_MiniProgram.MallBaseId),FiledValue=model.MallBaseId,OperatorEnum=OperatorEnum.Equal}
                };
                miniProgramRepository.Update(fileds, whereHelpers, trans);

                mallBaseRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetDefaultLogisticsRules");
                mallBaseRepository.DBSession.Rollback("SetDefaultLogisticsRules");
                return false;
            }
            return flag;
        }
        #endregion


        #region 物流设置
        /// <summary>
        /// 根据商户id获取物流信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics> GetLogisticsList(RB_Logistics query)
        {
            return logisticsRepository.GetListRepository(query);
        }


        /// <summary>
        /// 新增/修改基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateLogistics(RB_Logistics model)
        {
            if (model.ID == 0)
            {
                return logisticsRepository.Insert(model) > 0;
            }
            else
            {
                return logisticsRepository.Update(model);
            }
        }
        #endregion

        #region 物流规则设置
        /// <summary>
        /// 物料规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics_Rules_Extend> GetLogisticsRulesList(int pageIndex, int pageSize, out long rowCount, RB_Logistics_Rules_Extend query)
        {
            return logisticsRulesRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 物流规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics_Rules_Extend> GetLogisticsRulesList(RB_Logistics_Rules_Extend query)
        {
            return logisticsRulesRepository.GetLogisticsRulesList(query);
        }

        public RB_Logistics_Rules_Extend GetLogisticsRulesModel(RB_Logistics_Rules_Extend query)
        {
            RB_Logistics_Rules_Extend model = logisticsRulesRepository.GetLogisticsRulesList(query).FirstOrDefault();
            if (model != null && model.ID > 0)
            {
                //获取价格规则
                List<RB_Logistics_RulesPrice_Extend> ListPrice = logisticsRulesPriceRepository.GetListRepository(new RB_Logistics_RulesPrice_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, RulesId = model.ID });
                List<RB_Logistics_RulesRegion_Extend> listLogisticsRulesRegion = new List<RB_Logistics_RulesRegion_Extend>();

                if (ListPrice != null && ListPrice.Any())
                {
                    listLogisticsRulesRegion = logisticsRulesRegionRepository.GetListRepository(new RB_Logistics_RulesRegion_Extend { TenantId = query.TenantId, RulesType = model.RulesType, MallBaseId = query.MallBaseId, PriceIds = string.Join(",", ListPrice.Select(x => x.ID)) });

                }
                model.Detail = new List<RB_Logistics_RulesPrice_Extend>();
                model.Detail = ListPrice;

                foreach (var item in model.Detail)
                {
                    item.List = new List<RB_Logistics_RulesRegion_Extend>();
                    item.List = listLogisticsRulesRegion.Where(x => x.RulesPriceId == item.ID).ToList();
                }
            }
            else
            {
                model = new RB_Logistics_Rules_Extend();
                model.Detail = new List<RB_Logistics_RulesPrice_Extend>();
            }
            return model;
        }



        public bool SetDefaultLogisticsRules(RB_Logistics_Rules_Extend query)
        {
            bool flag = false;
            var trans = logisticsRulesRepository.DbTransaction;
            try
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Logistics_Rules.IsDefault),0},
                };
                IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                {
                    new WhereHelper (){ FiledName=nameof(RB_Logistics_Rules.MallBaseId),FiledValue=query.MallBaseId,OperatorEnum=OperatorEnum.Equal}
                };
                flag = logisticsRulesRepository.Update(fileds, whereHelpers, trans);

                IDictionary<string, object> filedsDefault = new Dictionary<string, object>()
                {
                    { nameof(RB_Logistics_Rules.IsDefault),1},
                };
                IList<WhereHelper> whereHelpersDefault = new List<WhereHelper>()
                {
                    new WhereHelper (){ FiledName=nameof(RB_Logistics_Rules.ID),FiledValue=query.ID,OperatorEnum=OperatorEnum.Equal}
                };
                flag = logisticsRulesRepository.Update(filedsDefault, whereHelpersDefault, trans);
                logisticsRulesRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetDefaultLogisticsRules");
                logisticsRulesRepository.DBSession.Rollback("SetDefaultLogisticsRules");
                return false;
            }
            return flag;
        }


        /// <summary>
        /// 新增/修改基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateLogisticsRules(RB_Logistics_Rules_Extend model)
        {
            bool flag = false;
            var trans = logisticsRulesRepository.DbTransaction;
            try
            {
                int rulesId = 0;
                if (model.ID == 0)
                {
                    rulesId = logisticsRulesRepository.Insert(model, trans);
                    flag = rulesId > 0;
                    if (model.Detail != null && model.Detail.Any())
                    {
                        foreach (var item in model.Detail)
                        {
                            item.RulesId = rulesId;
                            item.TenantId = model.TenantId;
                            item.MallBaseId = model.MallBaseId;
                            item.CreateDate = model.CreateDate;
                            item.UpdateDate = model.UpdateDate;
                            int priceId = logisticsRulesPriceRepository.Insert(item, trans);
                            item.List.ForEach(x => x.RulesPriceId = priceId);
                            item.List.ForEach(x => x.TenantId = model.TenantId);
                            item.List.ForEach(x => x.RulesType = model.RulesType);
                            item.List.ForEach(x => x.MallBaseId = model.MallBaseId);
                            item.List.ForEach(x => x.CreateDate = System.DateTime.Now);
                            item.List.ForEach(x => x.UpdateDate = System.DateTime.Now);
                            flag = logisticsRulesRegionRepository.InsertBatch(item.List, trans);
                        }
                    }
                }
                else
                {
                    rulesId = model.ID;
                    flag = logisticsRulesRepository.Update(model, trans);

                    //获取价格规则
                    List<RB_Logistics_RulesPrice_Extend> ListPrice = logisticsRulesPriceRepository.GetListRepository(new RB_Logistics_RulesPrice_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, RulesId = model.ID });

                    List<RB_Logistics_RulesRegion_Extend> listLogisticsRulesRegion = new List<RB_Logistics_RulesRegion_Extend>();

                    if (ListPrice != null && ListPrice.Any())
                    {
                        listLogisticsRulesRegion = logisticsRulesRegionRepository.GetListRepository(new RB_Logistics_RulesRegion_Extend { TenantId = model.TenantId, RulesType = model.RulesType, MallBaseId = model.MallBaseId, PriceIds = string.Join(",", ListPrice.Select(x => x.ID)) });
                    }


                    //比较之前有的现在没有的价格
                    List<string> notPriceList = new List<string>();
                    notPriceList = ListPrice.Select(x => x.ID.ToString()).Except(model.Detail.Select(x => x.ID.ToString())).ToList();
                    var deletePriceList = ListPrice.Where(x => notPriceList.Contains(x.ID.ToString()));
                    foreach (var item in deletePriceList)//删除之前有现在没有的数据
                    {
                        IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Logistics_RulesPrice.Status),1},
                             { nameof(RB_Logistics_RulesPrice.UpdateDate),model.UpdateDate},
                          };
                        IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Logistics_RulesPrice.ID),FiledValue=item.ID,OperatorEnum=OperatorEnum.Equal}
                        };
                        flag = logisticsRulesPriceRepository.Update(fileds, whereHelpers, trans);
                        if (listLogisticsRulesRegion != null && listLogisticsRulesRegion.Any())
                        {
                            foreach (var itemRegion in listLogisticsRulesRegion.Where(x => x.RulesPriceId == item.ID))
                            {
                                IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                         {
                            { nameof(RB_Logistics_RulesRegion.Status),1},
                             { nameof(RB_Logistics_RulesRegion.UpdateDate),System.DateTime.Now},
                          };
                                IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                            {
                                new WhereHelper (){ FiledName=nameof(RB_Logistics_RulesRegion.ID),FiledValue=itemRegion.ID,OperatorEnum=OperatorEnum.Equal}
                            };
                                flag = logisticsRulesRegionRepository.Update(filedsRegion, whereHelpersRegion, trans);
                            }
                        }

                    }

                    foreach (var item in model.Detail)
                    {
                        item.RulesId = rulesId;
                        item.TenantId = model.TenantId;
                        item.MallBaseId = model.MallBaseId;
                        int priceId = 0;

                        item.UpdateDate = model.UpdateDate;
                        if (item.ID == 0)
                        {
                            item.CreateDate = System.DateTime.Now;
                            priceId = logisticsRulesPriceRepository.Insert(item, trans);
                        }
                        else
                        {
                            priceId = item.ID;
                            flag = logisticsRulesPriceRepository.Update(item, trans);
                            //删除之前的区域
                            foreach (var itemRegion in listLogisticsRulesRegion.Where(x => x.RulesPriceId == item.ID))
                            {
                                IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                                 {
                                    { nameof(RB_Logistics_RulesRegion.Status),1},
                                    { nameof(RB_Logistics_RulesRegion.UpdateDate),System.DateTime.Now},
                                  };
                                IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                                {
                                    new WhereHelper (){ FiledName=nameof(RB_Logistics_RulesRegion.ID),FiledValue=itemRegion.ID,OperatorEnum=OperatorEnum.Equal}
                                };
                                flag = logisticsRulesRegionRepository.Update(filedsRegion, whereHelpersRegion, trans);
                            }
                        }
                        item.List.ForEach(x => x.RulesPriceId = priceId);
                        item.List.ForEach(x => x.CreateDate = System.DateTime.Now);
                        item.List.ForEach(x => x.UpdateDate = System.DateTime.Now);
                        item.List.ForEach(x => x.ID = 0);
                        item.List.ForEach(x => x.TenantId = model.TenantId);
                        item.List.ForEach(x => x.RulesType = model.RulesType);
                        item.List.ForEach(x => x.MallBaseId = model.MallBaseId);
                        flag = logisticsRulesRegionRepository.InsertBatch(item.List, trans);
                    }
                }
                logisticsRulesRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateLogisticsRules");
                logisticsRulesRepository.DBSession.Rollback("AddOrUpdateLogisticsRules");
                return false;
            }
            return flag;
        }





        /// <summary>
        /// 删除物流规则
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelRulesInfo(int id, int uid, int mallBaseId)
        {
            bool flag = false;
            var trans = logisticsRulesRepository.DbTransaction;
            try
            {
                Dictionary<string, object> cols = new Dictionary<string, object>()
                {
                    { nameof(RB_Logistics_Rules.Status),1},
                    { nameof(RB_Logistics_Rules.UpdateDate),DateTime.Now},
                };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Rules.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Rules.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Rules.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
                flag = logisticsRulesRepository.Update(cols, wheres1, trans);

                //获取价格规则
                List<RB_Logistics_RulesPrice_Extend> ListPrice = logisticsRulesPriceRepository.GetListRepository(new RB_Logistics_RulesPrice_Extend { TenantId = uid, MallBaseId = mallBaseId, RulesId = id });
                foreach (var item in ListPrice)
                {
                    IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Logistics_RulesPrice.Status),1},

                          };
                    IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Logistics_RulesPrice.ID),FiledValue=item.ID,OperatorEnum=OperatorEnum.Equal}
                        };
                    flag = logisticsRulesPriceRepository.Update(fileds, whereHelpers, trans);

                    IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                                 {
                                    { nameof(RB_Logistics_RulesRegion.Status),1},
                                    { nameof(RB_Logistics_RulesRegion.UpdateDate),System.DateTime.Now},
                                  };
                    IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                                {
                                    new WhereHelper (){ FiledName=nameof(RB_Logistics_RulesRegion.RulesPriceId),FiledValue=item.ID,OperatorEnum=OperatorEnum.Equal},
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_RulesRegion.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_RulesRegion.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_RulesRegion.RulesType),
                        FiledValue=Convert.ToInt32(Common.Enum.MallBase.RulesTypeEnum.Rule),
                        OperatorEnum=OperatorEnum.Equal
                }  };
                    flag = logisticsRulesRegionRepository.Update(filedsRegion, whereHelpersRegion, trans);
                }

                logisticsRulesRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelRulesInfo");
                logisticsRulesRepository.DBSession.Rollback("DelRulesInfo");
                return false;
            }
            return flag;
        }
        #endregion


        #region 包邮规则
        /// <summary>
        /// 包邮规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics_Rules_Extend> GetLogisticsPinkageList(int pageIndex, int pageSize, out long rowCount, RB_Logistics_Rules_Extend query)
        {
            List<RB_Logistics_Rules_Extend> list = logisticsRulesRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
            if (list != null && list.Any())
            {
                List<RB_Logistics_RulesRegion_Extend> listLogisticsRulesRegion = logisticsRulesRegionRepository.GetListRepository(new RB_Logistics_RulesRegion_Extend { TenantId = query.TenantId, RulesType = Common.Enum.MallBase.RulesTypeEnum.Pinkage, MallBaseId = query.MallBaseId, PriceIds = string.Join(",", list.Select(x => x.ID)) });
                foreach (var item in list)
                {
                    item.List = new List<RB_Logistics_RulesRegion_Extend>();
                    item.List = listLogisticsRulesRegion.Where(x => x.RulesPriceId == item.ID).ToList();
                }
            }
            return list;
        }

        /// <summary>
        /// 包邮实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Logistics_Rules_Extend GetPinkageModel(RB_Logistics_Rules_Extend query)
        {
            RB_Logistics_Rules_Extend model = logisticsRulesRepository.GetLogisticsRulesList(query).FirstOrDefault();
            if (model != null)
            {
                List<RB_Logistics_RulesRegion_Extend> listLogisticsRulesRegion = logisticsRulesRegionRepository.GetListRepository(new RB_Logistics_RulesRegion_Extend { TenantId = query.TenantId, RulesType = query.RulesType, MallBaseId = query.MallBaseId, RulesPriceId = model.ID });
                model.List = new List<RB_Logistics_RulesRegion_Extend>();
                model.List = listLogisticsRulesRegion;
            }

            return model;
        }

        /// <summary>
        /// 新增/修改基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdatePinkage(RB_Logistics_Rules_Extend model)
        {
            bool flag = false;
            var trans = logisticsRulesRepository.DbTransaction;
            try
            {
                int rulesId = 0;
                if (model.ID == 0)
                {
                    rulesId = logisticsRulesRepository.Insert(model, trans);
                    flag = rulesId > 0;
                }
                else
                {
                    rulesId = model.ID;
                    flag = logisticsRulesRepository.Update(model, trans);

                    List<RB_Logistics_RulesRegion_Extend> listLogisticsRulesRegion = logisticsRulesRegionRepository.GetListRepository(new RB_Logistics_RulesRegion_Extend { TenantId = model.TenantId, RulesType = model.RulesType, MallBaseId = model.MallBaseId, RulesPriceId = model.ID });

                    //删除之前的区域
                    foreach (var itemRegion in listLogisticsRulesRegion.Where(x => x.RulesPriceId == model.ID))
                    {
                        IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                                 {
                                    { nameof(RB_Logistics_RulesRegion.Status),1},
                                    { nameof(RB_Logistics_RulesRegion.UpdateDate),System.DateTime.Now},
                                  };
                        IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                                {
                                    new WhereHelper (){ FiledName=nameof(RB_Logistics_RulesRegion.ID),FiledValue=itemRegion.ID,OperatorEnum=OperatorEnum.Equal}
                                };
                        logisticsRulesRegionRepository.Update(filedsRegion, whereHelpersRegion, trans);
                    }
                }
                if (model.List != null && model.List.Any())
                {
                    model.List.ForEach(x => x.TenantId = model.TenantId);
                    model.List.ForEach(x => x.CreateDate = System.DateTime.Now);
                    model.List.ForEach(x => x.ID = 0);
                    model.List.ForEach(x => x.RulesPriceId = rulesId);
                    model.List.ForEach(x => x.RulesType = model.RulesType);
                    model.List.ForEach(x => x.MallBaseId = model.MallBaseId);
                    logisticsRulesRegionRepository.InsertBatch(model.List, trans);
                }

                logisticsRulesRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdatePinkage");
                logisticsRulesRepository.DBSession.Rollback("AddOrUpdatePinkage");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 删除包邮规则
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelPinkageInfo(int id, int uid, int mallBaseId)
        {
            bool flag = false;
            var trans = logisticsRulesRepository.DbTransaction;
            try
            {
                Dictionary<string, object> cols = new Dictionary<string, object>()
                {
                    { nameof(RB_Logistics_Rules.Status),1},
                    { nameof(RB_Logistics_Rules.UpdateDate),DateTime.Now},
                };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Rules.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Rules.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Rules.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Rules.RulesType),
                        FiledValue=Convert.ToInt32(Common.Enum.MallBase.RulesTypeEnum.Pinkage),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
                flag = logisticsRulesRepository.Update(cols, wheres1, trans);

                IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                                 {
                                    { nameof(RB_Logistics_RulesRegion.Status),1},
                                    { nameof(RB_Logistics_RulesRegion.UpdateDate),System.DateTime.Now},
                                  };
                IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                                {
                                    new WhereHelper (){ FiledName=nameof(RB_Logistics_RulesRegion.RulesPriceId),FiledValue=id,OperatorEnum=OperatorEnum.Equal},
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_RulesRegion.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_RulesRegion.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_RulesRegion.RulesType),
                        FiledValue=Convert.ToInt32(Common.Enum.MallBase.RulesTypeEnum.Pinkage),
                        OperatorEnum=OperatorEnum.Equal
                }  };
                flag = logisticsRulesRegionRepository.Update(filedsRegion, whereHelpersRegion, trans);
                logisticsRulesRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelPinkageInfo");
                logisticsRulesRepository.DBSession.Rollback("DelPinkageInfo");
                return false;
            }
            return flag;
        }
        #endregion

        #region 退货地址
        /// <summary>
        /// 退货地址列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics_Delivery_Extend> GetDeliveryPageList(int pageIndex, int pageSize, out long rowCount, RB_Logistics_Delivery_Extend query)
        {
            return deliveryRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 退货地址列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics_Delivery_Extend> GetLogisticsDeliveryList(RB_Logistics_Delivery_Extend query)
        {
            return deliveryRepository.GetLogisticsDeliveryList(query);
        }


        /// <summary>
        /// 删除收货地址
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool DelDelivery(RB_Logistics_Delivery_Extend model)
        {
            Dictionary<string, object> cols = new Dictionary<string, object>()
                {
                    { nameof(RB_Logistics_Delivery.Status),1},
                    { nameof(RB_Logistics_Delivery.UpdateDate),DateTime.Now},
                };
            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Delivery.ID),
                        FiledValue=model.ID,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Delivery.TenantId),
                        FiledValue=Convert.ToInt32(model.TenantId),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Delivery.MallBaseId),
                        FiledValue=Convert.ToInt32(model.MallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return deliveryRepository.Update(cols, wheres1);
        }


        public bool SetDefaultLogisticsDelivery(RB_Logistics_Delivery_Extend query)
        {
            bool flag = false;
            var trans = deliveryRepository.DbTransaction;
            try
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Logistics_Rules.IsDefault),0},
                };
                IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                {
                    new WhereHelper (){ FiledName=nameof(RB_Logistics_Delivery.MallBaseId),FiledValue=query.MallBaseId,OperatorEnum=OperatorEnum.Equal},
                     new WhereHelper (){ FiledName=nameof(RB_Logistics_Delivery.TenantId),FiledValue=query.TenantId,OperatorEnum=OperatorEnum.Equal}
                };
                deliveryRepository.Update(fileds, whereHelpers, trans);

                IDictionary<string, object> filedsDefault = new Dictionary<string, object>()
                {
                    { nameof(RB_Logistics_Rules.IsDefault),1},
                };
                IList<WhereHelper> whereHelpersDefault = new List<WhereHelper>()
                {
                    new WhereHelper (){ FiledName=nameof(RB_Logistics_Delivery.ID),FiledValue=query.ID,OperatorEnum=OperatorEnum.Equal}
                };
                deliveryRepository.Update(filedsDefault, whereHelpersDefault, trans);
                deliveryRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetDefaultLogisticsDelivery");
                deliveryRepository.DBSession.Rollback("SetDefaultLogisticsDelivery");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 新增/修改收货地址
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateDelivery(RB_Logistics_Delivery_Extend model)
        {
            if (model.ID == 0)
            {
                return deliveryRepository.Insert(model) > 0;
            }
            else
            {
                return deliveryRepository.Update(model);
            }
        }

        #endregion


        #region 快递公司
        /// <summary>
        /// 快递公司列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics_Express> GetLogisticsExpressList(RB_Logistics_Express query)
        {
            return expressRepository.GetLogisticsExpressList(query);
        }
        #endregion


        #region 电子面单
        /// <summary>
        ///电子面单列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_ElectronicSheet_Extend> GetElectronicSheetPage(int pageIndex, int pageSize, out long rowCount, RB_ElectronicSheet_Extend query)
        {
            return electronicSheetRepository.GetElectronicSheetPage(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 电子面单列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_ElectronicSheet_Extend> GetElectronicSheetList(RB_ElectronicSheet_Extend query)
        {
            return electronicSheetRepository.GetElectronicSheetList(query);
        }


        /// <summary>
        /// 删除电子面单
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool DelElectronicSheet(RB_ElectronicSheet_Extend model)
        {
            Dictionary<string, object> cols = new Dictionary<string, object>()
                {
                    { nameof(RB_ElectronicSheet.Status),1},
                    { nameof(RB_ElectronicSheet.UpdateDate),DateTime.Now},
                };
            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_ElectronicSheet.ID),
                        FiledValue=model.ID,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_ElectronicSheet.TenantId),
                        FiledValue=Convert.ToInt32(model.TenantId),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_ElectronicSheet.MallBaseId),
                        FiledValue=Convert.ToInt32(model.MallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return electronicSheetRepository.Update(cols, wheres1);
        }

        /// <summary>
        /// 设置默认电子面单
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public bool SetDefaultElectronicSheet(RB_ElectronicSheet_Extend query)
        {
            bool flag = false;
            var trans = electronicSheetRepository.DbTransaction;
            try
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Logistics_Rules.IsDefault),0},
                };
                IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                {
                    new WhereHelper (){ FiledName=nameof(RB_ElectronicSheet.MallBaseId),FiledValue=query.MallBaseId,OperatorEnum=OperatorEnum.Equal},
                     new WhereHelper (){ FiledName=nameof(RB_ElectronicSheet.TenantId),FiledValue=query.TenantId,OperatorEnum=OperatorEnum.Equal},
                };
                electronicSheetRepository.Update(fileds, whereHelpers, trans);

                IDictionary<string, object> filedsDefault = new Dictionary<string, object>()
                {
                    { nameof(RB_Logistics_Rules.IsDefault),1},
                };
                IList<WhereHelper> whereHelpersDefault = new List<WhereHelper>()
                {
                    new WhereHelper (){ FiledName=nameof(RB_ElectronicSheet.ID),FiledValue=query.ID,OperatorEnum=OperatorEnum.Equal}
                };
                electronicSheetRepository.Update(filedsDefault, whereHelpersDefault, trans);
                electronicSheetRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetDefaultLogisticsDelivery");
                electronicSheetRepository.DBSession.Rollback("SetDefaultLogisticsDelivery");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 新增/修改电子面单
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateElectronicSheet(RB_ElectronicSheet_Extend model)
        {
            if (model.ID == 0)
            {
                return electronicSheetRepository.Insert(model) > 0;
            }
            else
            {
                return electronicSheetRepository.Update(model);
            }
        }
        #endregion

        #region 上传设置
        /// <summary>
        /// 获取上传存储信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_File_Store> GetFileStoreList(RB_File_Store query)
        {
            return storeRepository.GetListRepository(query);
        }


        /// <summary>
        /// 新增/修改存储位置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateFileStore(RB_File_Store model)
        {
            if (model.ID == 0)
            {
                return storeRepository.Insert(model) > 0;
            }
            else
            {
                return storeRepository.Update(model);
            }
        }
        #endregion

        #region 分类包邮规则

        /// <summary>
        /// 新增/修改基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateIsFreeShipping(int mallId, int IsFreeShipping)
        {
            try
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_MallBase.IsFreeShipping),IsFreeShipping},
                };
                IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                {
                    new WhereHelper (){ FiledName=nameof(RB_MallBase.ID),FiledValue=mallId,OperatorEnum=OperatorEnum.Equal}
                };
                return mallBaseRepository.Update(fileds, whereHelpers);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateIsFreeShipping");
                mallBaseRepository.DBSession.Rollback("AddOrUpdateIsFreeShipping");
                return false;
            }
        }


        /// <summary>
        /// 分类包邮规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_FreeShipping_Extend> GetFreeShippingList(int pageIndex, int pageSize, out long rowCount, RB_FreeShipping_Extend query)
        {
            List<RB_FreeShipping_Extend> list = freeShippingRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
            if (list != null && list.Any())
            {
                List<RB_FreeShippingCategory_Extend> listLogisticsRulesRegion = freeShippingCategoryRepository.GetFreeShippingCategoryList(new RB_FreeShippingCategory_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, FreeShippingIds = string.Join(",", list.Select(x => x.ID)) });
                foreach (var item in list)
                {
                    item.CategoryList = new List<RB_FreeShippingCategory_Extend>();
                    item.CategoryList = listLogisticsRulesRegion.Where(x => x.FreeShippingId == item.ID).ToList();
                }
            }
            return list;
        }

        /// <summary>
        /// 分类包邮规则
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_FreeShipping_Extend GetFreeShippingModel(RB_FreeShipping_Extend query)
        {
            RB_FreeShipping_Extend model = freeShippingRepository.GetFreeShippingList(query).FirstOrDefault();
            if (model != null)
            {
                List<RB_FreeShippingCategory_Extend> listLogisticsRulesRegion = freeShippingCategoryRepository.GetFreeShippingCategoryList(new RB_FreeShippingCategory_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, FreeShippingId = model.ID });
                model.CategoryList = new List<RB_FreeShippingCategory_Extend>();
                model.CategoryList = listLogisticsRulesRegion;
            }

            return model;
        }


        /// <summary>
        /// 物流规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_FreeShipping_Extend> GetFreeShippingListByCategoryIds(RB_FreeShipping_Extend query)
        {
            return freeShippingRepository.GetFreeShippingListByCategoryIds(query);
        }

        /// <summary>
        /// 新增/修改分类包邮基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateFreeShipping(RB_FreeShipping_Extend model)
        {
            bool flag = false;
            var trans = freeShippingRepository.DbTransaction;
            try
            {
                int rulesId = 0;
                if (model.ID == 0)
                {
                    rulesId = freeShippingRepository.Insert(model, trans);
                    flag = rulesId > 0;
                    if (model.CategoryList != null && model.CategoryList.Any())
                    {
                        model.CategoryList.ForEach(x => x.TenantId = model.TenantId);
                        model.CategoryList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.CategoryList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.CategoryList.ForEach(x => x.ID = 0);
                        model.CategoryList.ForEach(x => x.FreeShippingId = rulesId);
                        model.CategoryList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        freeShippingCategoryRepository.InsertBatch(model.CategoryList, trans);
                    }
                }
                else
                {
                    rulesId = model.ID;
                    flag = freeShippingRepository.Update(model, trans);

                    List<RB_FreeShippingCategory_Extend> rlist = freeShippingCategoryRepository.GetFreeShippingCategoryList(new RB_FreeShippingCategory_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, FreeShippingId = model.ID });

                    #region 验证比例是否修改
                    var rUpdateList = rlist.Where(x => model.CategoryList.Select(z => z.FreeShippingId).Contains(x.FreeShippingId)).ToList();
                    var rDelList = rlist.Where(x => !model.CategoryList.Select(z => z.FreeShippingId).Contains(x.FreeShippingId)).ToList();
                    var rInsertList = model.CategoryList.Where(x => !rlist.Select(z => z.FreeShippingId).Contains(x.FreeShippingId)).ToList();

                    foreach (var item in rUpdateList)
                    {
                        var rmodel = model.CategoryList.Where(x => x.FreeShippingId == item.FreeShippingId).FirstOrDefault();
                        Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                { nameof(RB_FreeShippingCategory.CategoryId),rmodel.CategoryId}
                            };
                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                new WhereHelper(){
                                     FiledName=nameof(RB_FreeShippingCategory.ID),
                                      FiledValue=item.ID,
                                       OperatorEnum=OperatorEnum.Equal
                                }
                            };
                        freeShippingCategoryRepository.Update(keyValues1, wheres1, trans);
                    }
                    foreach (var item in rDelList)
                    {
                        freeShippingCategoryRepository.Delete(item, trans);
                    }
                    foreach (var item in rInsertList)
                    {
                        item.TenantId = model.TenantId;
                        item.CreateDate = System.DateTime.Now;
                        item.UpdateDate = System.DateTime.Now;
                        item.ID = 0;
                        item.FreeShippingId = rulesId;
                        item.MallBaseId = model.MallBaseId;
                        freeShippingCategoryRepository.Insert(item, trans);
                    }
                    #endregion
                }
                freeShippingRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateFreeShipping");
                freeShippingRepository.DBSession.Rollback("AddOrUpdateFreeShipping");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 新增/修改基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateIsEnable(int id, int IsEnable)
        {
            try
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_FreeShipping.IsEnable),IsEnable},
                };
                IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                {
                    new WhereHelper (){ FiledName=nameof(RB_FreeShipping.ID),FiledValue=id,OperatorEnum=OperatorEnum.Equal}
                };
                return freeShippingRepository.Update(fileds, whereHelpers);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateIsEnable");
                mallBaseRepository.DBSession.Rollback("AddOrUpdateIsEnable");
                return false;
            }
        }


        /// <summary>
        /// 删除分类包邮规则
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelFreeShipping(int id, int uid, int mallBaseId)
        {
            bool flag = false;
            var trans = freeShippingRepository.DbTransaction;
            try
            {
                Dictionary<string, object> cols = new Dictionary<string, object>()
                {
                    { nameof(RB_FreeShipping.Status),1},
                    { nameof(RB_FreeShipping.UpdateDate),DateTime.Now},
                };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_FreeShipping.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_FreeShipping.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_FreeShipping.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
                flag = freeShippingRepository.Update(cols, wheres1, trans);

                IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的分类
                                 {
                                    { nameof(RB_FreeShippingCategory.Status),1},
                                    { nameof(RB_FreeShippingCategory.UpdateDate),System.DateTime.Now},
                                  };
                IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                                {
                                    new WhereHelper (){ FiledName=nameof(RB_FreeShippingCategory.FreeShippingId),FiledValue=id,OperatorEnum=OperatorEnum.Equal},
                new WhereHelper(){
                        FiledName=nameof(RB_FreeShippingCategory.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_FreeShippingCategory.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }  };
                flag = freeShippingCategoryRepository.Update(filedsRegion, whereHelpersRegion, trans);
                freeShippingRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelFreeShipping");
                freeShippingRepository.DBSession.Rollback("DelFreeShipping");
                return false;
            }
            return flag;
        }


        /// <summary>
        /// 分类包邮规则分类信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_FreeShippingCategory_Extend> GetFreeShippingCategoryList(RB_FreeShippingCategory_Extend query)
        {
            return freeShippingCategoryRepository.GetFreeShippingCategoryList(query);
        }


        /// <summary>
        /// 验证重复
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="Name"></param>
        /// <param name="RB_Group_Id"></param>
        /// <param name="RB_Branch_Id"></param>
        /// <returns></returns>
        public bool ExistsName(int ID, string Name, int TenantId, int MallBaseId)
        {
            IList<WhereHelper> where = new List<WhereHelper>()
            {
                new WhereHelper() { FiledName = nameof(RB_FreeShipping.Status), FiledValue = 0, OperatorEnum = OperatorEnum.Equal },
                new WhereHelper() { FiledName = nameof(RB_FreeShipping.Name), FiledValue = Name.Trim(), OperatorEnum = OperatorEnum.Equal  },
                new WhereHelper() { FiledName = nameof(RB_FreeShipping.TenantId), FiledValue = TenantId, OperatorEnum = OperatorEnum.Equal  },
                new WhereHelper() { FiledName = nameof(RB_FreeShipping.MallBaseId), FiledValue = MallBaseId, OperatorEnum = OperatorEnum.Equal },
            };
            if (ID > 0)
            {
                where.Add(new WhereHelper() { FiledName = nameof(RB_FreeShipping.ID), FiledValue = ID.ToString(), OperatorEnum = OperatorEnum.NotEqual });
            }
            return freeShippingRepository.Exists(where);
        }

        #endregion

        #region 微店基础配置信息

        /// <summary>
        /// 微店基础配置
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MicroShop_Basics> GetMicroShopBasicsPageList(int pageIndex, int pageSize, out long rowCount, RB_MicroShop_Basics query)
        {
            return microShopBasicsRepository.GetMicroShopBasicsPageList(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 微店基础配置
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MicroShop_Basics> GetMicroShopBasicsList(RB_MicroShop_Basics query)
        {
            return microShopBasicsRepository.GetMicroShopBasicsList(query);
        }

        public bool AddOrUpdateMicroShopBasics(RB_MicroShop_Basics model)
        {
            if (model.ID == 0)
            {
                return microShopBasicsRepository.Insert(model) > 0;
            }
            else
            {
                return microShopBasicsRepository.Update(model);
            }
        }

        #endregion


    }
}
