﻿using System;
using VT.FW.DB;
using Mall.Common.Plugin;

namespace Mall.Model.Entity.Property
{

    /// <summary>
    /// 耗材出库申请实体
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "PropertyConnection")]
    public class RB_Supplies_StockOutApplyFor
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 总数量
        /// </summary>
        public int TotalNumber { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 状态 0 正常 1删除
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 公司
        /// </summary>
        public int RB_Branch_Id { get; set; }

        /// <summary>
        /// 集团
        /// </summary>
        public int RB_Group_Id { get; set; }

        /// <summary>
        /// CreateBy
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// CreateDate
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// UpdateBy
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// UpdateDate
        /// </summary>
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 关联财务单据id（英文逗号分隔）
        /// </summary>
        public string FinanceIds { get; set; }

        /// <summary>
        /// 出库状态   1未出库  2部分出库  3已出库
        /// </summary>
        public int StockOutStatus { get; set; }

        /// <summary>
        /// 审核状态  1审核中   2通过   3驳回
        /// </summary>
        public int AuditStatus { get; set; }

        /// <summary>
        /// 审核备注
        /// </summary>
        public string AuditRemark { get; set; }

        /// <summary>
        /// 审核人
        /// </summary>
        public int AuditEmpId { get; set; }

        /// <summary>
        /// 审核时间
        /// </summary>
        public DateTime? AuditDate { get; set; }

        /// <summary>
        /// 类型  1主营业务   2其他业务
        /// </summary>
        public int Type { get; set; }

        /// <summary>
        /// 电商关联订单ID
        /// </summary>
        public int MallOrderId { get; set; }

        /// <summary>
        /// 电商关联凭证
        /// </summary>
        public string MallRelevance { get; set; }

    }
}