﻿using Mall.Common.Enum;
using Mall.Common.Enum.TradePavilion;
using System;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 商会活动报名实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Commerce_Consult
    {
		/// <summary>
		/// 主键编号
		/// </summary>
		public int Id { get; set; }

		/// <summary>
		/// 活动编号
		/// </summary>
		public int ActivityId { get; set; }

		/// <summary>
		/// 用户编号
		/// </summary>
		public int UserId { get; set; }

		/// <summary>
		/// 联系人
		/// </summary>
		public string LinkMan { get; set; }

		/// <summary>
		/// 联系电话
		/// </summary>
		public string LinkTel { get; set; }

		/// <summary>
		/// 商户号id
		/// </summary>
		public int TenantId { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// 报名时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }

        /// <summary>
        /// 报名人数
        /// </summary>
        public int PeopleNum { get; set; }

        /// <summary>
        /// 单价（点数）
        /// </summary>
        public int UnitPrice { get; set; }

        /// <summary>
        /// 支付点数
        /// </summary>
        public int Money { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 是否申请取消  1是  2否
        /// </summary>
        public int IsApplyForCancel { get; set; }

        /// <summary>
        /// 取消备注
        /// </summary>
        public string CancelRemark { get; set; }

        /// <summary>
        /// 申请取消审核状态  1同意  2拒绝
        /// </summary>
        public int ApplyForCancelStatus { get; set; }

        /// <summary>
        /// 拒绝备注
        /// </summary>
        public string RejectRemark { get; set; }

        /// <summary>
        /// 活动ids
        /// </summary>
        public string ActivityIds { get; set; }

        /// <summary>
        /// 单位/企业/机构名称
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// 性质
        /// </summary>
        public NatureEnum? Nature { get; set; }

        /// <summary>
        /// 职务
        /// </summary>
        public string Post { get; set; }

        /// <summary>
        /// 所属国籍/省/市
        /// </summary>
        public string CountryInfo { get; set; }

        /// <summary>
        /// 年龄
        /// </summary>
        public int Age { get; set; }

        /// <summary>
        /// 身份证号码
        /// </summary>
        public string IdCard { get; set; }

        /// <summary>
        /// 是否完成新冠病毒疫苗全程接种【1是/0否】
        /// </summary>
        public int IsInoculate { get; set; }

        /// <summary>
        /// 活动前21天有港台地区和国外旅居史。【1是/0否】
        /// </summary>
        public int IsGATLJ { get; set; }

        /// <summary>
        /// 活动前21天有港台地区和国外旅居史【备注】
        /// </summary>
        public string GATLJRemark { get; set; }

        /// <summary>
        /// 活动前14天内有境内中高风险地区及所在县（市、区）旅居史【1是/0否】
        /// </summary>
        public int IsZGFX { get; set; }

        /// <summary>
        /// 活动前14天内有境内中高风险地区及所在县（市、区）旅居史【备注】
        /// </summary>
        public string ZGFXRemark { get; set; }

        /// <summary>
        /// 活动前14天有来自新冠肺炎确诊病例、无症状感染者报告社区的发热和/或有呼吸道症状患者接触史【1是/0否】
        /// </summary>
        public int IsQZJC { get; set; }

        /// <summary>
        /// 活动前14天有来自新冠肺炎确诊病例、无症状感染者报告社区的发热和/或有呼吸道症状患者接触史【备注】
        /// </summary>
        public string QZJCRemark { get; set; }

        /// <summary>
        /// 活动前14天有居家隔离医学观察人员接触史【1是/0否】
        /// </summary>
        public int IsJJGLGX { get; set; }

        /// <summary>
        /// 活动前14天有居家隔离医学观察人员接触史【备注】
        /// </summary>
        public string JJGLGXRemark { get; set; }

        /// <summary>
        /// 已治愈出院的确诊病例和已解除集中隔离医学观察的无症状感染者，尚在随访或医学观察期内【1是/0否】
        /// </summary>
        public int IsZYCYJCGL { get; set; }

        /// <summary>
        /// 已治愈出院的确诊病例和已解除集中隔离医学观察的无症状感染者，尚在随访或医学观察期内【备注】
        /// </summary>
        public string ZYCYJCGLRemark { get; set; }

        /// <summary>
        /// 被判定为新冠肺炎病毒感染者（确诊病例或无症状感染者）的密切接触者和密接的密接【1是/0否】
        /// </summary>
        public int IsMJ { get; set; }

        /// <summary>
        /// 被判定为新冠肺炎病毒感染者（确诊病例或无症状感染者）的密切接触者和密接的密接【备注】
        /// </summary>
        public string MJRemark { get; set; }

        /// <summary>
        /// 有发热、干咳、乏力、咽痛、嗅（味）觉减退、腹泻等症状，且未排除传染病感染者【1是/0否】
        /// </summary>
        public int IsFRGK { get; set; }

        /// <summary>
        /// 有发热、干咳、乏力、咽痛、嗅（味）觉减退、腹泻等症状，且未排除传染病感染者【备注】
        /// </summary>
        public string FRGKRemark { get; set; }
    }
}
