﻿using System;
using Mall.Common.AOP;
using Mall.Common.Plugin;

namespace Mall.Model.Entity.Property
{

    /// <summary>
    /// 耗材档案实体
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "PropertyConnection")]
    public class RB_Supplies_Material
    {

        /// <summary>
        /// rId
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 物料名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 物料编码
        /// </summary>        
        public string SuppliesNum
        {
            get;
            set;
        }
        /// <summary>
        /// 分类id
        /// </summary>        
        public int? CategoryId
        {
            get;
            set;
        }
        /// <summary>
        /// 品牌
        /// </summary>        
        public string BrandName
        {
            get;
            set;
        }
        /// <summary>
        /// 型号
        /// </summary>        
        public string SuppliesModel
        {
            get;
            set;
        }
        /// <summary>
        /// 库存单位
        /// </summary>        
        public string Units
        {
            get;
            set;
        }
        /// <summary>
        /// 金额
        /// </summary>        
        public decimal? Money
        {
            get;
            set;
        }
        /// <summary>
        /// 安全库存
        /// </summary>        
        public int? SafetyStock
        {
            get;
            set;
        }
        /// <summary>
        /// 预留库存
        /// </summary>        
        public int? ReservedStock
        {
            get;
            set;
        }
        /// <summary>
        /// 条形码号
        /// </summary>        
        public string Barcode
        {
            get;
            set;
        }
        /// <summary>
        /// 供应商名称
        /// </summary>        
        public string SupplierName
        {
            get;
            set;
        }
        /// <summary>
        /// 物料图片
        /// </summary>        
        public string Images
        {
            get;
            set;
        }
        /// <summary>
        /// 备注
        /// </summary>        
        public string Remark
        {
            get;
            set;
        }
        /// <summary>
        /// 状态 0 正常 1删除
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 公司
        /// </summary>        
        public int? RB_Branch_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 集团
        /// </summary>        
        public int? RB_Group_Id
        {
            get;
            set;
        }
        /// <summary>
        /// CreateBy
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateBy
        /// </summary>        
        public int? UpdateBy
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}