﻿using VT.FW.DB;
using Mall.Common.Enum.MallBase;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.BaseSetUp
{
    /// <summary>
    /// 运费规则
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Logistics_Rules
    {
        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 0-否1-是
        /// </summary>
        public int IsDefault { get; set; }

        /// <summary>
        /// 规则名称
        /// </summary>
        public string RulesName { get; set; }

        /// <summary>
        /// 计费方式
        /// </summary>
        public ChargeModeEnum ChargeMode { get; set; }

        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }

        public RulesTypeEnum RulesType { get; set; }


        /// <summary>
        /// 是否开启起送规则
        /// </summary>
        public int IsOpenMinPrice { get; set; }


        /// <summary>
        /// 起送价格
        /// </summary>
        public int IsOpenAllRegionPrice { get; set; }

        /// <summary>
        /// 全地区起送金额
        /// </summary>
        public int AllRegionPrice { get; set; }

    }
}
