﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Education
{
    /// <summary>
    /// 活动配置实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "EduConnection")]
    public class RB_Activity_Config
    {
        /// <summary>
        /// id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 类型  1按人头   2百分比
        /// </summary>
        public int Type { get; set; }

        /// <summary>
        /// 提成金额/比例   
        /// </summary>
        public decimal CommissionMoney { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 集团id
        /// </summary>
        public int Group_Id { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateTime { get; set; }
    }
}
