﻿using Mall.Model.Entity.TradePavilion;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Extend.TradePavilion
{
    /// <summary>
    ///【商载通】 载体、楼宇申请扩展表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_CarrierEnterpriseApplyFor_Extend : RB_CarrierEnterpriseApplyFor
    {
        /// <summary>
        /// 地铁信息
        /// </summary>
        public List<RB_CarrierEnterpriseMetroApplyFor_Extend> CarrierMetroList { get; set; }

        /// <summary>
        /// 介绍图
        /// </summary>
        public List<string> BannerList { get; set; }

        /// <summary>
        /// 载体荣誉图
        /// </summary>
        public List<string> HonorList { get; set; }

        /// <summary>
        /// 排序
        /// </summary>
        public int OrderBy { get; set; }

        /// <summary>
        /// 开业时间
        /// </summary>
        public string StartOpenTime { get; set; }
        /// <summary>
        /// 开业时间
        /// </summary>
        public string EndOpenTime { get; set; }
        /// <summary>
        /// 地铁线路
        /// </summary>
        public int MetroNum { get; set; }


        /// <summary>
        /// 站点名称
        /// </summary>
        public string MetroName { get; set; }

        /// <summary>
        /// 收藏id
        /// </summary>
        public int CollectId { get; set; }

        /// <summary>
        /// 导出选中的字段
        /// </summary>
        public List<int> ExcelEnumIds { get; set; }

        /// <summary>
        /// 项目类型
        /// </summary>
        public string ProjectName { get; set; }

        /// <summary>
        /// 分类名称
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// 首店数量
        /// </summary>
        public List<FirstShopNumModel> FirstShopNumList { get; set; }
    }
}
