﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common;
using Mall.Common.Plugin;
using Newtonsoft.Json;
using Mall.Common.API;
using Newtonsoft.Json.Linq;
using VT.FW.DB;
using Mall.Repository.Miai;
using Mall.Model.Extend.Miai;
using Mall.Model.Entity.Education;

namespace Mall.Module.Miai
{
    /// <summary>
    /// 相亲处理层
    /// </summary>
    public class MiaiModule
    {
        private readonly RB_Miai_ForumRepository miai_ForumRepository = new RB_Miai_ForumRepository();


        private readonly RB_MiAi_BaseInfoRepository miai_BaseInfoRepository = new RB_MiAi_BaseInfoRepository();


        private readonly RB_MiAi_FollowMemberRepository miai_FollowMemberRepository = new RB_MiAi_FollowMemberRepository();

        #region 活动版块
        /// <summary>
        /// 获取活动版本分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Miai_Forum_Extend> GetForumPageList(int pageIndex, int pageSize, out long count, RB_Miai_Forum_Extend dmodel)
        {
            return miai_ForumRepository.GetPageList(pageIndex, pageSize, out count, dmodel);
        }

        #endregion

        #region 会员基础信息


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_BaseInfo_Extend> GetBaseInfoList(RB_MiAi_BaseInfo_Extend where)
        {
            return miai_BaseInfoRepository.GetBaseInfoList(where);
        }


        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_BaseInfo_Extend> GetBaseInfoPageList(int pageIndex, int pageSize, out long rowsCount, RB_MiAi_BaseInfo_Extend where)
        {
            return miai_BaseInfoRepository.GetBaseInfoPageList(pageIndex, pageSize, out rowsCount, where);
        }

        /// <summary>
        /// 新增用户的基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetMiAiBaseInfo(RB_MiAi_BaseInfo_Extend model)
        {
            bool flag = false;
            if (model.Id == 0)
            {
                flag = miai_BaseInfoRepository.Insert(model) > 0;
            }
            return flag;
        }
        #endregion

        #region 我的粉丝/我的关注
        /// <summary>
        /// 新增/修改我关注的会员配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateFollowMember(RB_MiAi_FollowMember model)
        {
            bool flag = false;
            try
            {

                if (model.ID == 0)
                {
                    flag = miai_FollowMemberRepository.Insert(model) > 0;
                }
                else
                {
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Education_FollowTeacher.UpdateDate),System.DateTime.Now},
                        { nameof(RB_Education_FollowTeacher.Status),model.Status}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_MiAi_FollowMember.ID),
                              FiledValue=model.ID,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    flag = miai_FollowMemberRepository.Update(keyValues, wheres);
                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateFollowMember");
                return false;
            }
            return flag;
        }


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_FollowMember_Extend> GetFollowMemberList(RB_MiAi_FollowMember_Extend where)
        {
            return miai_FollowMemberRepository.GetFollowMemberList(where);
        }

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_FollowMember_Extend> GetFollowMemberPageList(int pageIndex, int pageSize, out long rowsCount, RB_MiAi_FollowMember_Extend where)
        {
            var list = miai_FollowMemberRepository.GetFollowMemberPageList(pageIndex, pageSize, out rowsCount, where);

            if (list != null && list.Any())
            {
                string createByIds = string.Join(",", list.Select(x => x.UserId));
                var fansList = miai_FollowMemberRepository.GetFollowMemberList(new RB_MiAi_FollowMember_Extend { TenantId = where.TenantId, MallBaseId = where.MallBaseId, UserId = where.CreateBy, CreateByIds = createByIds });
                foreach (var item in list)
                {
                    item.IsMutualFollow = fansList.Where(x => x.CreateBy == item.UserId).Count();
                    if (item.IsMutualFollow > 0)
                    {
                        item.MutualFollowId = fansList.Where(x => x.CreateBy == item.UserId).FirstOrDefault().ID;
                    }

                }
            }
            return list;
        }

        /// <summary>
        /// 我的粉丝分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_FollowMember_Extend> GetFollowFansPageList(int pageIndex, int pageSize, out long rowsCount, RB_MiAi_FollowMember_Extend where)
        {
            var list = miai_FollowMemberRepository.GetFollowFansPageList(pageIndex, pageSize, out rowsCount, where);
            if (list != null && list.Any())
            {
                string createByIds = string.Join(",", list.Select(x => x.CreateBy));
                var fansList = miai_FollowMemberRepository.GetFollowMemberList(new RB_MiAi_FollowMember_Extend { TenantId = where.TenantId, MallBaseId = where.MallBaseId, CreateBy = where.UserId, UserIds = createByIds });
                foreach (var item in list)
                {
                    item.IsMutualFollow = fansList.Where(x => x.UserId == item.CreateBy).Count();
                    if (item.IsMutualFollow > 0)
                    {
                        item.MutualFollowId = fansList.Where(x => x.UserId == item.CreateBy).FirstOrDefault().ID;
                    }
                }
            }
            return list;
        }
        #endregion

    }
}
