﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.AOP;
using Mall.Module.Miai;
using Mall.Model.Extend.Miai;
using Mall.Model.Entity.Education;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletMiaiController : BaseController
    {
        private readonly MiaiModule miaiModule = new MiaiModule();

        #region 活动版块

        #endregion

        #region 基础信息

        /// <summary>
        /// 填写个人基础信息
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSetMiAiBaseInfo()
        {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            AppletUserInfo uInfo = UserReidsCache.GetAppletUserBlacklistInfo(userInfo.UserId);
            if ((uInfo?.Blacklist ?? 0) == 1)
            {
                return ApiResult.Failed("已进入黑名单，无法访问");
            }

            RB_MiAi_BaseInfo_Extend baseInfo = JsonConvert.DeserializeObject<RB_MiAi_BaseInfo_Extend>(req.msg.ToString());
            baseInfo.Status = 0;
            baseInfo.CreateDate = DateTime.Now;
            baseInfo.UserId = userInfo.UserId;
            baseInfo.TenantId = userInfo.TenantId;
            baseInfo.MallBaseId = userInfo.MallBaseId;
            if (baseInfo.Sex == 0)
            {
                return ApiResult.Failed("请选择性别");
            }
            if (string.IsNullOrWhiteSpace(baseInfo.Birthday))
            {
                return ApiResult.Failed("请选择生日");
            }
            if (baseInfo.Weight == 0)
            {
                return ApiResult.Failed("请选择体重");
            }
            if (baseInfo.Height == 0)
            {
                return ApiResult.Failed("请选择身高");
            }
            if (baseInfo.Height == 0)
            {
                return ApiResult.Failed("请选择身高");
            }
            if (!baseInfo.EducationType.HasValue || (int)baseInfo.EducationType == 0)
            {
                return ApiResult.Failed("请选择学历");
            }
            if (!baseInfo.Marriage.HasValue || (int)baseInfo.Marriage == 0)
            {
                return ApiResult.Failed("请选择婚姻状况");
            }
            if (string.IsNullOrWhiteSpace(baseInfo.IDCardNo))
            {
                return ApiResult.Failed("请填写身份证号");
            }
            if (string.IsNullOrWhiteSpace(baseInfo.RealName))
            {
                return ApiResult.Failed("请填写姓名");
            }
            if (string.IsNullOrWhiteSpace(baseInfo.IDCard))
            {
                return ApiResult.Failed("请上传身份证头像面");
            }
            if (string.IsNullOrWhiteSpace(baseInfo.IDCardBack))
            {
                return ApiResult.Failed("请上传身份证国徽面");
            }
            var oldBaseInfo = miaiModule.GetBaseInfoList(new RB_MiAi_BaseInfo_Extend { UserId = baseInfo.UserId, TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId }).FirstOrDefault();
            if (oldBaseInfo == null && oldBaseInfo.Id == 0)
            {
                if (miaiModule.SetMiAiBaseInfo(baseInfo))
                {
                    return ApiResult.Success("基础资料填写成功");
                }
                else
                {
                    return ApiResult.Failed("基础资料填写失败");
                }
            }
            else
            {
                return ApiResult.Failed("请勿重复填写基础资料");
            }
        }



        /// <summary>
        /// 获取教育枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetEducationTypeEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.MiAi.EducationTypeEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取婚姻枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMarriageEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.MiAi.MarriageEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }
        #endregion


        #region 我的粉丝/我的关注
        /// <summary>
        /// 我的关注
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFollowTeacherPageList()
        {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_MiAi_FollowMember_Extend demodel = JsonConvert.DeserializeObject<RB_MiAi_FollowMember_Extend>(req.msg.ToString());
            demodel.CreateBy = userInfo.UserId;
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            var list = miaiModule.GetFollowMemberPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.UserId,
                x.Name,
                x.Photo,
                x.CreateBy,
                x.IsMutualFollow,
                x.MutualFollowId,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:ss:mm"),

            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 我的粉丝
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFollowFansPageList()
        {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_MiAi_FollowMember_Extend demodel = JsonConvert.DeserializeObject<RB_MiAi_FollowMember_Extend>(req.msg.ToString());
            demodel.UserId = userInfo.UserId;
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            var list = miaiModule.GetFollowFansPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.UserId,
                x.Name,
                x.Photo,
                x.CreateBy,
                x.IsMutualFollow,
                x.MutualFollowId,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:ss:mm"),

            });
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 关注老师
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFollowMember()
        {
            var parms = RequestParm;
            var userInfo = AppletUserInfo;
            var query = JsonConvert.DeserializeObject<RB_MiAi_FollowMember>(RequestParm.msg.ToString());
            query.TenantId = userInfo.TenantId;
            query.MallBaseId = userInfo.MallBaseId;
            query.CreateBy = userInfo.UserId;

            bool isUpdate = true;

            if (query == null)
            {
                return ApiResult.Failed("请传入我关注的会员信息");
            }
            else
            {
                //判断是否已经关注过
                var oldList = miaiModule.GetFollowMemberList(new RB_MiAi_FollowMember_Extend { Status = -1, UserId = query.UserId, CreateBy = query.CreateBy, MallBaseId = query.MallBaseId, TenantId = query.TenantId }); ;
                if (query.ID == 0)
                {
                    isUpdate = false;
                    query.CreateDate = System.DateTime.Now;
                    query.UpdateDate = System.DateTime.Now;
                    if (query.UserId <= 0)
                    {
                        return ApiResult.Failed("请传入我关注的会员信息");
                    }
                    if (oldList != null && oldList.Any(x => x.Status == 0))
                    {
                        return ApiResult.Failed("您已关注，请勿重复操作");
                    }
                    else
                    {
                        if (oldList != null && oldList.Any())
                        {
                            query.ID = oldList.OrderByDescending(x => x.CreateDate).FirstOrDefault().ID;
                        }
                        query.Status = 0;
                    }
                }
                else
                {
                    query.Status = 1;
                }

                bool result = miaiModule.AddOrUpdateFollowMember(query);
                if (isUpdate)
                {
                    if (result)
                    {
                        return ApiResult.Success("取消关注成功");
                    }
                    else
                    {
                        return ApiResult.Failed("取消关注成功");
                    }
                }
                else
                {
                    if (result)
                    {
                        return ApiResult.Success("关注成功");
                    }
                    else
                    {
                        return ApiResult.Failed("关注成功");
                    }
                }
            }
        }
        #endregion
    }
}