﻿using Mall.WeChat.Common;
using Mall.Common.Pay.WeChatPat.Model;
using System;
using Newtonsoft.Json.Linq;
using Newtonsoft.Json;

namespace Mall.Common.Pay.WeChatPat
{
    /// <summary>
    /// Token帮助类
    /// </summary>
    public class TokenHelper
    {

        /// <summary>
        /// 获取token
        /// </summary>
        /// <param name="token"></param>
        /// <returns></returns>
        public static string GetLXYToken(string token, string Appid, string Secret)
        {
            //向微信服务端 获取token
            string url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + Appid + "&secret=" + Secret;
            string type = "utf-8";
            Mall.Common.Plugin.GetUsersHelper GetUsersHelper = new Mall.Common.Plugin.GetUsersHelper();
            string wenXinResult = string.Empty;
            JObject jo = null;
            Mall.Common.Plugin.result res = new Mall.Common.Plugin.result();
            try
            {
                wenXinResult = GetUsersHelper.GetUrltoHtml(url, type);
                jo = (JObject)JsonConvert.DeserializeObject(wenXinResult);
                token = jo["access_token"].ToString();
            }
            catch (Exception ex)
            {
                Plugin.LogHelper.Write(ex, string.Format("GetWx:wenXinResult:{0}", wenXinResult));
            }
            return token;
        }

        /// <summary>
        /// 获取微信用户头像
        /// </summary>
        /// <param name="access_token"></param>
        /// <param name="openid"></param>
        /// <returns></returns>
        public static string GetWeiXinUserPhoto(string access_token, string openid) 
        {
            openid = openid.Replace("/t", "");
            string url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=" + access_token + "&openid=" + openid + "&lang=zh_CN";            
            //string url = "https://api.weixin.qq.com/sns/userinfo?access_token=" + access_token + "&openid=" + openid + "&lang=zh_CN";
            string type = "utf-8";
            Mall.Common.Plugin.GetUsersHelper GetUsersHelper = new Mall.Common.Plugin.GetUsersHelper();
            string wenXinResult = string.Empty;
            string Photo = "";
            try
            {
                wenXinResult = GetUsersHelper.GetUrltoHtml(url, type);
                var jo = (JObject)JsonConvert.DeserializeObject(wenXinResult);
                Photo = jo["headimgurl"].ToString();
            }
            catch (Exception ex)
            {
                Plugin.LogHelper.Write(ex, string.Format("GetWx:GetWeiXinUserPhoto:{0}", wenXinResult));
            }
            return Photo;
        }

        /// <summary>
        /// 获取赞羊下级用户
        /// </summary>
        /// <param name="UserId"></param>
        /// <returns></returns>
        public static string GetZYUserInfo(int UserId,string cookie)
        {
            string url = "http://wx.weibaoge.cn/web/index.php?r=mall%2Fshare%2Fteam&status=1&id=" + UserId;            
            string wenXinResult = string.Empty;
            string data = "";
            try
            {
                wenXinResult = Mall.Common.Plugin.HttpHelper.HttpGet(url, System.Text.Encoding.UTF8, "", cookie);
                var jo = (JObject)JsonConvert.DeserializeObject(wenXinResult);
                if (jo["code"].ToString() == "0") {
                    data = jo["data"].ToString();                    
                }
            }
            catch (Exception ex)
            {
                Plugin.LogHelper.Write(ex, string.Format("GetZYUserInfo:{0}", wenXinResult));
            }
            return data;
        }
    }


}
