﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common;
using Mall.Common.Plugin;
using Newtonsoft.Json;
using Mall.Common.API;
using Newtonsoft.Json.Linq;
using VT.FW.DB;
using Mall.Repository.Miai;
using Mall.Model.Extend.Miai;

namespace Mall.Module.Miai
{
    /// <summary>
    /// 相亲处理层
    /// </summary>
    public class MiaiModule
    {
        private readonly RB_Miai_ForumRepository miai_ForumRepository = new RB_Miai_ForumRepository();


        private readonly RB_MiAi_BaseInfoRepository miai_BaseInfoRepository = new RB_MiAi_BaseInfoRepository();

        #region 活动版块
        /// <summary>
        /// 获取活动版本分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Miai_Forum_Extend> GetForumPageList(int pageIndex, int pageSize, out long count, RB_Miai_Forum_Extend dmodel)
        {
            return miai_ForumRepository.GetPageList(pageIndex, pageSize, out count, dmodel);
        }

        #endregion

        #region 会员基础信息


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_BaseInfo_Extend> GetBaseInfoList(RB_MiAi_BaseInfo_Extend where)
        {
            return miai_BaseInfoRepository.GetBaseInfoList(where);
        }


        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_BaseInfo_Extend> GetBaseInfoPageList(int pageIndex, int pageSize, out long rowsCount, RB_MiAi_BaseInfo_Extend where)
        {
            return miai_BaseInfoRepository.GetBaseInfoPageList(pageIndex, pageSize, out rowsCount, where);
        }

        /// <summary>
        /// 新增用户的基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetMiAiBaseInfo(RB_MiAi_BaseInfo_Extend model)
        {
            bool flag = false;
            if (model.Id == 0)
            {
                flag = miai_BaseInfoRepository.Insert(model) > 0;
            }
            return flag;
        }
        #endregion

    }
}
