﻿
using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 投资采购仓储层
    /// </summary>
    public class RB_InvestmentProcurementRepository : BaseRepository<RB_InvestmentProcurement>
    {
        /// <summary>
        /// 获取投资采购分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_InvestmentProcurement_Extend> GetInvestmentProcurementPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_InvestmentProcurement_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_InvestmentProcurement
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Company_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_InvestmentProcurement_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_InvestmentProcurement_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_InvestmentProcurement_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.CompanyName))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_Company_Extend.CompanyName));
                    parameters.Add("Name", "%" + query.CompanyName.Trim() + "%");
                }
            }
            return GetPage<RB_InvestmentProcurement_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}
