﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Coffee
{

    /// <summary>
    /// 用户咖啡劵信息
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_CoffeeCoupons
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 用户ID
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 购买的咖啡劵数量
        /// </summary>
        public int TotalBuyNum { get; set; }

        /// <summary>
        /// 剩余购买的数量
        /// </summary>
        public int SurplusBugNum { get; set; }

        /// <summary>
        /// 剩余免费的数量  （每月1日 初始化）
        /// </summary>
        public int FreeNum { get; set; }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }
    }
}
