﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Goods;
using VT.FW.DB;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 甲鹤小程序优惠表实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_Preferential
    {
        /// <summary>
        /// 主键编号
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 商品编号
        /// </summary>
        public int GoodsId { get; set; }

        /// <summary>
        /// 优惠条件
        /// </summary>
        public string PreferentialTerms { get; set; }

        /// <summary>
        /// 销售返佣类型(0-百分比，1-固定金额)
        /// </summary>
        public int SaleCommissionType { get; set; }

        /// <summary>
        /// 销售返佣
        /// </summary>
        public decimal SaleCommissionMoney { get; set; }

        /// <summary>
        /// 同行返佣类型(0-百分比，1-固定金额)
        /// </summary>
        public int B2BCommissionType { get; set; }

        /// <summary>
        /// 同行返佣
        /// </summary>
        public decimal B2BCommissionMoney { get; set; }

        /// <summary>
        /// 课程价格优惠类型(见枚举)
        /// </summary>
        public CoursePriceDiscountEnum PriceDiscountType { get; set; }

        /// <summary>
        /// 购买人数
        /// </summary>
        public int BuyNum { get; set; }

        /// <summary>
        /// 赠送人数
        /// </summary>
        public int SendNum { get; set; }

        /// <summary>
        /// 优惠价格类型(0-百分比，1-固定金额)
        /// </summary>
        public int PriceType { get; set; }

        /// <summary>
        /// 优惠金额
        /// </summary>
        public decimal PriceMoney { get; set; }



        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 状态
        /// </summary>
        public Common.Enum.DateStateEnum Status { get; set; }

        /// <summary>
        /// 教育返佣类型(0-百分比，1-固定金额)
        /// </summary>
        public int EduCommissionType { get; set; }

        /// <summary>
        /// 教育同行佣金
        /// </summary>
        public decimal EduCommissionMoney { get; set; }
    }
}
